/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArraySet;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.extension.AABExtension;
import com.iqiyi.android.qigsaw.core.splitload.Split;
import com.iqiyi.android.qigsaw.core.splitload.SplitActivator;
import com.iqiyi.android.qigsaw.core.splitload.SplitCompatDexLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadException;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManager;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadReporterManager;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoaderImpl;
import com.iqiyi.android.qigsaw.core.splitload.listener.OnSplitLoadListener;
import com.iqiyi.android.qigsaw.core.splitreport.SplitLoadError;
import com.iqiyi.android.qigsaw.core.splitreport.SplitLoadReporter;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

final class SplitLoadTask
implements Runnable {
    private static final String TAG = "SplitLoadTask";
    private final List<Intent> splitFileIntents;
    private final OnSplitLoadListener loadListener;
    private final SplitLoadManager loadManager;
    private final SplitActivator splitActivator;
    private final Object mLock = new Object();
    private final List<String> moduleNames;

    SplitLoadTask(SplitLoadManager loadManager, @NonNull List<Intent> splitFileIntents, @Nullable OnSplitLoadListener loadListener) {
        this.loadManager = loadManager;
        this.splitActivator = new SplitActivator(AABExtension.getInstance());
        this.splitFileIntents = splitFileIntents;
        this.loadListener = loadListener;
        this.moduleNames = this.getRequestModuleNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            this.loadSplits();
        } else {
            Object object = this.mLock;
            synchronized (object) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = SplitLoadTask.this.mLock;
                        synchronized (object) {
                            SplitLoadTask.this.loadSplits();
                            SplitLoadTask.this.mLock.notifyAll();
                        }
                    }
                });
                try {
                    this.mLock.wait();
                }
                catch (InterruptedException e) {
                    List<SplitLoadError> errors = Collections.singletonList(new SplitLoadError(this.moduleNames.get(0), -26, (Throwable)e));
                    this.reportLoadResult(errors, 0L);
                }
            }
        }
    }

    private void loadSplits() {
        long lastTimeMillis = System.currentTimeMillis();
        SplitLoaderImpl loader = new SplitLoaderImpl(this.loadManager.getContext());
        ArraySet splits = new ArraySet(this.splitFileIntents.size());
        PathClassLoader classLoader = this.loadManager.getInjectedClassloader();
        ArrayList<SplitLoadError> errors = new ArrayList<SplitLoadError>(0);
        for (Intent splitFileIntent : this.splitFileIntents) {
            String splitName = splitFileIntent.getStringExtra("splitName");
            String splitApkPath = splitFileIntent.getStringExtra("apk");
            if (this.isSplitLoaded(splitName)) {
                SplitLog.i((String)TAG, (String)"Split %s has been loaded!", (Object[])new Object[]{splitName});
                continue;
            }
            try {
                ((SplitLoader)loader).load((ClassLoader)classLoader, splitFileIntent);
            }
            catch (SplitLoadException e) {
                SplitLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"Failed to load split %s, error code: %d", (Object[])new Object[]{splitName, e.getErrorCode()});
                errors.add(new SplitLoadError(splitName, e.getErrorCode(), e.getCause()));
                continue;
            }
            try {
                this.splitActivator.activate(splitName);
            }
            catch (SplitLoadException e) {
                SplitLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"Failed to activate %s", (Object[])new Object[]{splitName});
                errors.add(new SplitLoadError(splitName, e.getErrorCode(), e.getCause()));
                try {
                    SplitCompatDexLoader.unLoad((ClassLoader)classLoader);
                }
                catch (Throwable throwable) {}
                continue;
            }
            splits.add(new Split(splitName, splitApkPath));
            File splitDir = new File(splitFileIntent.getStringExtra("splitDir"));
            if (splitDir.setLastModified(System.currentTimeMillis())) continue;
            SplitLog.w((String)TAG, (String)("Failed to set last modified time for " + splitName), (Object[])new Object[0]);
        }
        this.loadManager.putSplits((Collection<Split>)splits);
        this.reportLoadResult(errors, System.currentTimeMillis() - lastTimeMillis);
    }

    private void reportLoadResult(List<SplitLoadError> errors, long cost) {
        SplitLoadReporter loadReporter = SplitLoadReporterManager.getLoadReporter();
        if (!errors.isEmpty()) {
            if (this.loadListener != null) {
                int lastErrorCode = errors.get(errors.size() - 1).getErrorCode();
                this.loadListener.onFailed(lastErrorCode);
            }
            if (loadReporter != null) {
                loadReporter.onLoadFailed(this.moduleNames, this.loadManager.getCurrentProcessName(), errors, cost);
            }
        } else {
            if (this.loadListener != null) {
                this.loadListener.onCompleted();
            }
            if (loadReporter != null) {
                loadReporter.onLoadOK(this.moduleNames, this.loadManager.getCurrentProcessName(), cost);
            }
        }
    }

    private List<String> getRequestModuleNames() {
        ArrayList<String> requestModuleNames = new ArrayList<String>(this.splitFileIntents.size());
        for (Intent intent : this.splitFileIntents) {
            requestModuleNames.add(intent.getStringExtra("splitName"));
        }
        return requestModuleNames;
    }

    private boolean isSplitLoaded(String splitName) {
        for (Split split : this.loadManager.getLoadedSplits()) {
            if (!split.splitName.equals(splitName)) continue;
            return true;
        }
        return false;
    }
}

