/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitload.HiddenApiReflection;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadException;
import java.lang.reflect.Field;
import java.util.List;

abstract class SplitLoader {
    static final String TAG = "SplitLoader";
    private Field mSplitResDirsField;
    private Object mPackageInfo;
    final Context context;

    SplitLoader(Context context) {
        this.context = context;
    }

    Context getBaseContext() {
        Context ctx = this.context;
        while (ctx instanceof ContextWrapper) {
            ctx = ((ContextWrapper)ctx).getBaseContext();
        }
        return ctx;
    }

    abstract void load(ClassLoader var1, Intent var2) throws SplitLoadException;

    protected abstract void loadResources(String var1) throws SplitLoadException;

    protected abstract void loadNativePath(ClassLoader var1, String var2) throws SplitLoadException;

    protected abstract void loadDex(ClassLoader var1, String var2, List<String> var3) throws SplitLoadException;

    private Field getFieldSplitResDirsInPackageInfo(Object packageInfo) {
        try {
            this.mSplitResDirsField = HiddenApiReflection.findField(packageInfo, "mSplitResDirs");
        }
        catch (NoSuchFieldException e) {
            SplitLog.w((String)TAG, (String)"Failed to reflect 'mSplitResDirs' field!", (Object[])new Object[0]);
        }
        return this.mSplitResDirsField;
    }

    void installSplitResourceDir(Context baseContext, String splitResDir) throws Throwable {
        Field mSplitResDirsField;
        Object packageInfo = this.getPackageInfo(baseContext);
        if (packageInfo != null && (mSplitResDirsField = this.getFieldSplitResDirsInPackageInfo(packageInfo)) != null) {
            String[] splitResDirs = (String[])mSplitResDirsField.get(packageInfo);
            if (splitResDirs == null) {
                mSplitResDirsField.set(packageInfo, new String[]{splitResDir});
            } else {
                int splitSourceDirsLength = splitResDirs.length;
                String[] combined = new String[splitSourceDirsLength + 1];
                String[] expanded = new String[]{splitResDir};
                System.arraycopy(splitResDirs, 0, combined, 0, splitResDirs.length);
                System.arraycopy(expanded, 0, combined, splitResDirs.length, expanded.length);
                mSplitResDirsField.set(packageInfo, combined);
            }
        }
    }

    private Object getPackageInfo(Context baseContext) {
        if (this.mPackageInfo == null) {
            try {
                this.mPackageInfo = HiddenApiReflection.findField(baseContext, "mPackageInfo").get(baseContext);
            }
            catch (Throwable e) {
                SplitLog.w((String)TAG, (String)"Failed to reflect 'mPackageInfo' instance!", (Throwable)e);
            }
        }
        return this.mPackageInfo;
    }
}

