/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArraySet;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.extension.AABExtension;
import com.iqiyi.android.qigsaw.core.splitload.Split;
import com.iqiyi.android.qigsaw.core.splitload.SplitActivator;
import com.iqiyi.android.qigsaw.core.splitload.SplitCompatDexLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadException;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManager;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadReporterManager;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoader;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoaderImpl;
import com.iqiyi.android.qigsaw.core.splitload.listener.OnSplitLoadListener;
import com.iqiyi.android.qigsaw.core.splitreport.SplitLoadError;
import com.iqiyi.android.qigsaw.core.splitreport.SplitLoadReporter;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class SplitLoadTask
implements Runnable {
    private static final String TAG = "SplitLoadTask";
    private final List<Intent> splitFileIntents;
    private final OnSplitLoadListener loadListener;
    private final SplitLoadManager loadManager;
    private final SplitActivator splitActivator;
    private final boolean needActivate;

    SplitLoadTask(SplitLoadManager loadManager, @NonNull List<Intent> splitFileIntents, @Nullable OnSplitLoadListener loadListener, boolean needActivate) {
        this.loadManager = loadManager;
        this.needActivate = needActivate;
        this.splitActivator = new SplitActivator(AABExtension.getInstance());
        this.splitFileIntents = splitFileIntents;
        this.loadListener = loadListener;
    }

    @Override
    public void run() {
        this.loadSplits();
    }

    private synchronized void loadSplits() {
        long lastTimeMillis = System.currentTimeMillis();
        SplitLoaderImpl loader = new SplitLoaderImpl(this.loadManager.getContext());
        ArraySet splits = new ArraySet(this.splitFileIntents.size());
        PathClassLoader classLoader = this.loadManager.getInjectedClassloader();
        ArrayList<SplitLoadError> errors = new ArrayList<SplitLoadError>(0);
        for (Intent splitFileIntent : this.splitFileIntents) {
            String splitName = splitFileIntent.getStringExtra("splitName");
            String splitApkPath = splitFileIntent.getStringExtra("apk");
            if (this.isSplitLoaded(splitName)) {
                SplitLog.i((String)TAG, (String)"Split %s has been loaded!", (Object[])new Object[]{splitName});
                continue;
            }
            try {
                ((SplitLoader)loader).load((ClassLoader)classLoader, splitFileIntent);
            }
            catch (SplitLoadException e) {
                SplitLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"Failed to load split %s, error code: %d", (Object[])new Object[]{splitName, e.getErrorCode()});
                errors.add(new SplitLoadError(splitName, e.getErrorCode(), e.getCause()));
                continue;
            }
            if (this.needActivate) {
                try {
                    this.splitActivator.activate(splitName);
                }
                catch (SplitLoadException e) {
                    SplitLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"Failed to activate %s", (Object[])new Object[]{splitName});
                    errors.add(new SplitLoadError(splitName, e.getErrorCode(), e.getCause()));
                    try {
                        SplitCompatDexLoader.unLoad((ClassLoader)classLoader);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
            }
            splits.add(new Split(splitName, splitApkPath));
            File splitDir = new File(splitFileIntent.getStringExtra("splitDir"));
            if (splitDir.setLastModified(System.currentTimeMillis())) continue;
            SplitLog.w((String)TAG, (String)("Failed to set last modified time for " + splitName), (Object[])new Object[0]);
        }
        this.loadManager.putSplits((Collection<Split>)splits);
        if (this.loadListener != null) {
            if (errors.isEmpty()) {
                this.loadListener.onCompleted();
            } else {
                int lastErrorCode = ((SplitLoadError)errors.get(errors.size() - 1)).getErrorCode();
                this.loadListener.onFailed(lastErrorCode);
            }
        }
        SplitLoadReporter loadReporter = SplitLoadReporterManager.getLoadReporter();
        List<String> requestModuleNames = this.getRequestModuleNames();
        if (errors.isEmpty()) {
            if (this.needActivate) {
                if (loadReporter != null) {
                    loadReporter.onLoadOKUnderUserTriggering(requestModuleNames, this.loadManager.getCurrentProcessName(), System.currentTimeMillis() - lastTimeMillis);
                }
            } else if (loadReporter != null) {
                loadReporter.onLoadOKUnderProcessStarting(requestModuleNames, this.loadManager.getCurrentProcessName(), System.currentTimeMillis() - lastTimeMillis);
            }
        } else if (this.needActivate) {
            if (loadReporter != null) {
                loadReporter.onLoadFailedUnderUserTriggering(requestModuleNames, this.loadManager.getCurrentProcessName(), errors, System.currentTimeMillis() - lastTimeMillis);
            }
        } else if (loadReporter != null) {
            loadReporter.onLoadFailedUnderProcessStarting(requestModuleNames, this.loadManager.getCurrentProcessName(), errors, System.currentTimeMillis() - lastTimeMillis);
        }
    }

    private List<String> getRequestModuleNames() {
        ArrayList<String> requestModuleNames = new ArrayList<String>(0);
        for (Intent intent : this.splitFileIntents) {
            requestModuleNames.add(intent.getStringExtra("splitName"));
        }
        return requestModuleNames;
    }

    private boolean isSplitLoaded(String splitName) {
        for (Split split : this.loadManager.getLoadedSplits()) {
            if (!split.splitName.equals(splitName)) continue;
            return true;
        }
        return false;
    }
}

