/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.os.Build;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitload.HiddenApiReflection;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class SplitCompatLibraryLoader {
    private static final String TAG = "SplitCompatLibraryLoader";

    SplitCompatLibraryLoader() {
    }

    static void load(ClassLoader classLoader, File folder) throws Throwable {
        if (folder == null || !folder.exists()) {
            SplitLog.e((String)TAG, (String)"load, folder %s is illegal", (Object[])new Object[]{folder});
            return;
        }
        if (Build.VERSION.SDK_INT == 25 && Build.VERSION.PREVIEW_SDK_INT != 0 || Build.VERSION.SDK_INT > 25) {
            try {
                V25.load(classLoader, folder);
            }
            catch (Throwable throwable) {
                SplitLog.e((String)TAG, (String)"load, v25 fail, sdk: %d, error: %s, try to fallback to V23", (Object[])new Object[]{Build.VERSION.SDK_INT, throwable.getMessage()});
                V23.load(classLoader, folder);
            }
        } else if (Build.VERSION.SDK_INT >= 23) {
            try {
                V23.load(classLoader, folder);
            }
            catch (Throwable throwable) {
                SplitLog.e((String)TAG, (String)"load, v23 fail, sdk: %d, error: %s, try to fallback to V14", (Object[])new Object[]{Build.VERSION.SDK_INT, throwable.getMessage()});
                V14.load(classLoader, folder);
            }
        } else if (Build.VERSION.SDK_INT >= 14) {
            V14.load(classLoader, folder);
        } else {
            V4.load(classLoader, folder);
        }
    }

    private static final class V25 {
        private V25() {
        }

        private static void load(ClassLoader classLoader, File folder) throws Throwable {
            Field pathListField = HiddenApiReflection.findField(classLoader, "pathList");
            Object dexPathList = pathListField.get(classLoader);
            Field nativeLibraryDirectories = HiddenApiReflection.findField(dexPathList, "nativeLibraryDirectories");
            ArrayList<File> origLibDirs = (ArrayList<File>)nativeLibraryDirectories.get(dexPathList);
            if (origLibDirs == null) {
                origLibDirs = new ArrayList<File>(2);
            }
            Iterator libDirIt = origLibDirs.iterator();
            while (libDirIt.hasNext()) {
                File libDir = (File)libDirIt.next();
                if (!folder.equals(libDir)) continue;
                libDirIt.remove();
                break;
            }
            origLibDirs.add(0, folder);
            Field systemNativeLibraryDirectories = HiddenApiReflection.findField(dexPathList, "systemNativeLibraryDirectories");
            ArrayList origSystemLibDirs = (ArrayList)systemNativeLibraryDirectories.get(dexPathList);
            if (origSystemLibDirs == null) {
                origSystemLibDirs = new ArrayList(2);
            }
            ArrayList<File> newLibDirs = new ArrayList<File>(origLibDirs.size() + origSystemLibDirs.size() + 1);
            newLibDirs.addAll(origLibDirs);
            newLibDirs.addAll(origSystemLibDirs);
            Method makeElements = HiddenApiReflection.findMethod(dexPathList, "makePathElements", List.class);
            Object[] elements = (Object[])makeElements.invoke(dexPathList, newLibDirs);
            Field nativeLibraryPathElements = HiddenApiReflection.findField(dexPathList, "nativeLibraryPathElements");
            nativeLibraryPathElements.set(dexPathList, elements);
        }
    }

    private static final class V23 {
        private V23() {
        }

        private static void load(ClassLoader classLoader, File folder) throws Throwable {
            Field pathListField = HiddenApiReflection.findField(classLoader, "pathList");
            Object dexPathList = pathListField.get(classLoader);
            Field nativeLibraryDirectories = HiddenApiReflection.findField(dexPathList, "nativeLibraryDirectories");
            ArrayList<File> origLibDirs = (ArrayList<File>)nativeLibraryDirectories.get(dexPathList);
            if (origLibDirs == null) {
                origLibDirs = new ArrayList<File>(2);
            }
            Iterator libDirIt = origLibDirs.iterator();
            while (libDirIt.hasNext()) {
                File libDir = (File)libDirIt.next();
                if (!folder.equals(libDir)) continue;
                libDirIt.remove();
                break;
            }
            origLibDirs.add(0, folder);
            Field systemNativeLibraryDirectories = HiddenApiReflection.findField(dexPathList, "systemNativeLibraryDirectories");
            ArrayList origSystemLibDirs = (ArrayList)systemNativeLibraryDirectories.get(dexPathList);
            if (origSystemLibDirs == null) {
                origSystemLibDirs = new ArrayList(2);
            }
            ArrayList<File> newLibDirs = new ArrayList<File>(origLibDirs.size() + origSystemLibDirs.size() + 1);
            newLibDirs.addAll(origLibDirs);
            newLibDirs.addAll(origSystemLibDirs);
            Method makeElements = HiddenApiReflection.findMethod(dexPathList, "makePathElements", List.class, File.class, List.class);
            ArrayList suppressedExceptions = new ArrayList();
            Object[] elements = (Object[])makeElements.invoke(dexPathList, newLibDirs, null, suppressedExceptions);
            Field nativeLibraryPathElements = HiddenApiReflection.findField(dexPathList, "nativeLibraryPathElements");
            nativeLibraryPathElements.set(dexPathList, elements);
        }
    }

    private static final class V14 {
        private V14() {
        }

        private static void load(ClassLoader classLoader, File folder) throws Throwable {
            Field pathListField = HiddenApiReflection.findField(classLoader, "pathList");
            Object dexPathList = pathListField.get(classLoader);
            Field nativeLibDirField = HiddenApiReflection.findField(dexPathList, "nativeLibraryDirectories");
            File[] origNativeLibDirs = (File[])nativeLibDirField.get(dexPathList);
            ArrayList<File> newNativeLibDirList = new ArrayList<File>(origNativeLibDirs.length + 1);
            newNativeLibDirList.add(folder);
            for (File origNativeLibDir : origNativeLibDirs) {
                if (folder.equals(origNativeLibDir)) continue;
                newNativeLibDirList.add(origNativeLibDir);
            }
            nativeLibDirField.set(dexPathList, newNativeLibDirList.toArray(new File[0]));
        }
    }

    private static final class V4 {
        private V4() {
        }

        private static void load(ClassLoader classLoader, File folder) throws Throwable {
            String addPath = folder.getPath();
            Field pathField = HiddenApiReflection.findField(classLoader, "libFile");
            String origLibPaths = (String)pathField.get(classLoader);
            String[] origLibPathSplit = origLibPaths.split(":");
            StringBuilder newLibPaths = new StringBuilder(addPath);
            for (String origLibPath : origLibPathSplit) {
                if (origLibPath == null || addPath.equals(origLibPath)) continue;
                newLibPaths.append(':').append(origLibPath);
            }
            pathField.set(classLoader, newLibPaths.toString());
            Field libraryPathElementsFiled = HiddenApiReflection.findField(classLoader, "libraryPathElements");
            List libraryPathElements = (List)libraryPathElementsFiled.get(classLoader);
            Iterator libPathElementIt = libraryPathElements.iterator();
            while (libPathElementIt.hasNext()) {
                String libPath = (String)libPathElementIt.next();
                if (!addPath.equals(libPath)) continue;
                libPathElementIt.remove();
                break;
            }
            libraryPathElements.add(0, addPath);
            libraryPathElementsFiled.set(classLoader, libraryPathElements);
        }
    }
}

