/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.os.Build;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitload.HiddenApiReflection;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class SplitCompatDexLoader {
    private static final String TAG = "SplitCompatDexLoader";
    private static int sPatchDexCount = 0;

    SplitCompatDexLoader() {
    }

    static void load(ClassLoader classLoader, File dexOptDir, List<File> files) throws Throwable {
        if (!files.isEmpty()) {
            if (Build.VERSION.SDK_INT >= 23) {
                V23.load(classLoader, files, dexOptDir);
            } else if (Build.VERSION.SDK_INT >= 19) {
                V19.load(classLoader, files, dexOptDir);
            } else if (Build.VERSION.SDK_INT >= 14) {
                V14.load(classLoader, files, dexOptDir);
            } else {
                throw new RuntimeException("don't support under SDK version 14!");
            }
            sPatchDexCount = files.size();
        }
    }

    static void unLoad(ClassLoader classLoader) throws Throwable {
        if (sPatchDexCount <= 0) {
            return;
        }
        if (Build.VERSION.SDK_INT < 14) {
            throw new RuntimeException("don't support under SDK version 14!");
        }
        Field pathListField = HiddenApiReflection.findField(classLoader, "pathList");
        Object dexPathList = pathListField.get(classLoader);
        HiddenApiReflection.reduceFieldArray(dexPathList, "dexElements", sPatchDexCount);
    }

    private static final class V14 {
        private V14() {
        }

        private static void load(ClassLoader loader, List<File> additionalClassPathEntries, File optimizedDirectory) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException {
            Field pathListField = HiddenApiReflection.findField(loader, "pathList");
            Object dexPathList = pathListField.get(loader);
            HiddenApiReflection.expandFieldArray(dexPathList, "dexElements", V14.makeDexElements(dexPathList, new ArrayList<File>(additionalClassPathEntries), optimizedDirectory));
        }

        private static Object[] makeDexElements(Object dexPathList, ArrayList<File> files, File optimizedDirectory) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            Method makeDexElements = HiddenApiReflection.findMethod(dexPathList, "makeDexElements", ArrayList.class, File.class);
            return (Object[])makeDexElements.invoke(dexPathList, files, optimizedDirectory);
        }
    }

    private static final class V19 {
        private V19() {
        }

        private static void load(ClassLoader loader, List<File> additionalClassPathEntries, File optimizedDirectory) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException, IOException {
            Iterator<IOException> iterator;
            Field pathListField = HiddenApiReflection.findField(loader, "pathList");
            Object dexPathList = pathListField.get(loader);
            ArrayList<IOException> suppressedExceptions = new ArrayList<IOException>();
            HiddenApiReflection.expandFieldArray(dexPathList, "dexElements", V19.makeDexElements(dexPathList, new ArrayList<File>(additionalClassPathEntries), optimizedDirectory, suppressedExceptions));
            if (suppressedExceptions.size() > 0 && (iterator = suppressedExceptions.iterator()).hasNext()) {
                IOException e = iterator.next();
                SplitLog.e((String)SplitCompatDexLoader.TAG, (String)"Exception in makeDexElement", (Throwable)e);
                throw e;
            }
        }

        private static Object[] makeDexElements(Object dexPathList, ArrayList<File> files, File optimizedDirectory, ArrayList<IOException> suppressedExceptions) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            Method makeDexElements;
            try {
                makeDexElements = HiddenApiReflection.findMethod(dexPathList, "makeDexElements", ArrayList.class, File.class, ArrayList.class);
            }
            catch (NoSuchMethodException e) {
                SplitLog.e((String)SplitCompatDexLoader.TAG, (String)"NoSuchMethodException: makeDexElements(ArrayList,File,ArrayList) failure", (Object[])new Object[0]);
                try {
                    makeDexElements = HiddenApiReflection.findMethod(dexPathList, "makeDexElements", List.class, File.class, List.class);
                }
                catch (NoSuchMethodException e1) {
                    SplitLog.e((String)SplitCompatDexLoader.TAG, (String)"NoSuchMethodException: makeDexElements(List,File,List) failure", (Object[])new Object[0]);
                    throw e1;
                }
            }
            return (Object[])makeDexElements.invoke(dexPathList, files, optimizedDirectory, suppressedExceptions);
        }
    }

    private static final class V23 {
        private V23() {
        }

        private static void load(ClassLoader loader, List<File> additionalClassPathEntries, File optimizedDirectory) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InvocationTargetException, NoSuchMethodException, IOException {
            Iterator<IOException> iterator;
            Field pathListField = HiddenApiReflection.findField(loader, "pathList");
            Object dexPathList = pathListField.get(loader);
            ArrayList<IOException> suppressedExceptions = new ArrayList<IOException>();
            HiddenApiReflection.expandFieldArray(dexPathList, "dexElements", V23.makePathElements(dexPathList, new ArrayList<File>(additionalClassPathEntries), optimizedDirectory, suppressedExceptions));
            if (suppressedExceptions.size() > 0 && (iterator = suppressedExceptions.iterator()).hasNext()) {
                IOException e = iterator.next();
                SplitLog.e((String)SplitCompatDexLoader.TAG, (String)"Exception in makePathElement", (Throwable)e);
                throw e;
            }
        }

        private static Object[] makePathElements(Object dexPathList, ArrayList<File> files, File optimizedDirectory, ArrayList<IOException> suppressedExceptions) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            Method makePathElements;
            try {
                makePathElements = HiddenApiReflection.findMethod(dexPathList, "makePathElements", List.class, File.class, List.class);
            }
            catch (NoSuchMethodException e) {
                SplitLog.e((String)SplitCompatDexLoader.TAG, (String)"NoSuchMethodException: makePathElements(List,File,List) failure", (Object[])new Object[0]);
                try {
                    makePathElements = HiddenApiReflection.findMethod(dexPathList, "makePathElements", ArrayList.class, File.class, ArrayList.class);
                }
                catch (NoSuchMethodException e1) {
                    SplitLog.e((String)SplitCompatDexLoader.TAG, (String)"NoSuchMethodException: makeDexElements(ArrayList,File,ArrayList) failure", (Object[])new Object[0]);
                    try {
                        SplitLog.w((String)SplitCompatDexLoader.TAG, (String)"NoSuchMethodException: try use v19 instead", (Object[])new Object[0]);
                        return V19.makeDexElements(dexPathList, files, optimizedDirectory, suppressedExceptions);
                    }
                    catch (NoSuchMethodException e2) {
                        SplitLog.e((String)SplitCompatDexLoader.TAG, (String)"NoSuchMethodException: makeDexElements(List,File,List) failure", (Object[])new Object[0]);
                        throw e2;
                    }
                }
            }
            return (Object[])makePathElements.invoke(dexPathList, files, optimizedDirectory, suppressedExceptions);
        }
    }
}

