/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitload;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitload.HiddenApiReflection;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManager;
import com.iqiyi.android.qigsaw.core.splitload.SplitLoadManagerService;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SplitCompatResourcesLoader {
    private static final String TAG = "SplitCompatResourcesLoader";
    private static final Object sLock = new Object();

    @SuppressLint(value={"PrivateApi"})
    public static void loadResources(Activity activity, Resources preResources) throws Throwable {
        SplitCompatResourcesLoader.checkOrUpdateResources((Context)activity, preResources);
    }

    public static void loadResources(Service service) throws Throwable {
        SplitCompatResourcesLoader.checkOrUpdateResources((Context)service, service.getBaseContext().getResources());
    }

    public static void loadResources(BroadcastReceiver receiver, Context context, Resources resources) throws Throwable {
        SplitCompatResourcesLoader.checkOrUpdateResources(context, resources);
    }

    static void loadResources(Context context, Resources preResources, String splitApkPath) throws Throwable {
        List<String> loadedResDirs = SplitCompatResourcesLoader.getLoadedResourcesDirs(preResources.getAssets());
        if (!loadedResDirs.contains(splitApkPath)) {
            SplitCompatResourcesLoader.installSplitResDirs(context, preResources, splitApkPath);
            SplitLog.d((String)TAG, (String)"Install split %s resources for application.", (Object[])new Object[]{splitApkPath});
        }
    }

    private static void checkOrUpdateResources(Context context, Resources resources) throws Throwable {
        List<String> loadedResDirsInAsset = SplitCompatResourcesLoader.getLoadedResourcesDirs(resources.getAssets());
        Collection<String> loadedSplitPaths = SplitCompatResourcesLoader.getLoadedSplitPaths();
        if (loadedSplitPaths != null && !loadedSplitPaths.isEmpty() && !loadedResDirsInAsset.containsAll(loadedSplitPaths)) {
            for (String splitPath : loadedSplitPaths) {
                if (loadedResDirsInAsset.contains(splitPath)) continue;
                SplitCompatResourcesLoader.installSplitResDirs(context, resources, splitPath);
            }
        }
    }

    private static Collection<String> getLoadedSplitPaths() {
        SplitLoadManager loadManager = SplitLoadManagerService.getInstance();
        if (loadManager != null) {
            return loadManager.getLoadedSplitApkPaths();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installSplitResDirs(final Context context, final Resources resources, final String splitFileDir) throws Throwable {
        if (Build.VERSION.SDK_INT >= 21) {
            V21.installSplitResDirs(resources, splitFileDir);
        } else if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            SplitLog.i((String)TAG, (String)"Install res on main thread", (Object[])new Object[0]);
            V14.installSplitResDirs(context, resources, splitFileDir);
        } else {
            Object object = sLock;
            synchronized (object) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = sLock;
                        synchronized (object) {
                            try {
                                V14.installSplitResDirs(context, resources, splitFileDir);
                            }
                            catch (Throwable throwable) {
                                throw new RuntimeException(throwable);
                            }
                            sLock.notify();
                        }
                    }
                });
                sLock.wait();
            }
        }
    }

    private static List<String> getLoadedResourcesDirs(AssetManager asset) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        ArrayList<String> existedAppResDirList = new ArrayList<String>();
        if (Build.VERSION.SDK_INT >= 28) {
            Object[] apkAssets;
            for (Object apkAsset : apkAssets = (Object[])VersionCompat.getGetApkAssetsMethod().invoke((Object)asset, new Object[0])) {
                String path = (String)VersionCompat.getGetAssetPathMethod().invoke(apkAsset, new Object[0]);
                existedAppResDirList.add(path);
            }
        } else {
            Object[] appStringBlocks = (Object[])VersionCompat.getmStringBlocksField().get(asset);
            int totalResCount = appStringBlocks.length;
            for (int appResIndex = 1; appResIndex <= totalResCount; ++appResIndex) {
                String inApp = (String)VersionCompat.getGetCookieNameMethod().invoke((Object)asset, appResIndex);
                existedAppResDirList.add(inApp);
            }
        }
        return existedAppResDirList;
    }

    private static abstract class VersionCompat {
        private static Field mStringBlocksField;
        private static Field mAssetsField;
        private static Field mTypedArrayPoolField;
        private static Method addAssetPathMethod;
        private static Method ensureStringBlocksMethod;
        private static Method getCookieNameMethod;
        private static Method getAssetPathMethod;
        private static Method getApkAssetsMethod;

        private VersionCompat() {
        }

        static Field getmStringBlocksField() throws NoSuchFieldException {
            if (mStringBlocksField == null) {
                mStringBlocksField = HiddenApiReflection.findField(AssetManager.class, "mStringBlocks");
            }
            return mStringBlocksField;
        }

        static Field getmAssetsField() throws NoSuchFieldException {
            if (mAssetsField == null) {
                mAssetsField = HiddenApiReflection.findField(Resources.class, "mAssets");
            }
            return mAssetsField;
        }

        static Field getmTypedArrayPoolField() throws NoSuchFieldException {
            if (mTypedArrayPoolField == null) {
                mTypedArrayPoolField = HiddenApiReflection.findField(Resources.class, "mTypedArrayPool");
            }
            return mTypedArrayPoolField;
        }

        static Method getAddAssetPathMethod() throws NoSuchMethodException {
            if (addAssetPathMethod == null) {
                addAssetPathMethod = HiddenApiReflection.findMethod(AssetManager.class, "addAssetPath", String.class);
            }
            return addAssetPathMethod;
        }

        static Method getGetCookieNameMethod() throws NoSuchMethodException {
            if (getCookieNameMethod == null) {
                getCookieNameMethod = HiddenApiReflection.findMethod(AssetManager.class, "getCookieName", Integer.TYPE);
            }
            return getCookieNameMethod;
        }

        static Method getEnsureStringBlocksMethod() throws NoSuchMethodException {
            if (ensureStringBlocksMethod == null) {
                ensureStringBlocksMethod = HiddenApiReflection.findMethod(AssetManager.class, "ensureStringBlocks", new Class[0]);
            }
            return ensureStringBlocksMethod;
        }

        @SuppressLint(value={"PrivateApi"})
        @RequiresApi(value=28)
        static Method getGetAssetPathMethod() throws ClassNotFoundException, NoSuchMethodException {
            if (getAssetPathMethod == null) {
                Class<?> clazz = Class.forName("android.content.res.ApkAssets");
                getAssetPathMethod = HiddenApiReflection.findMethod(clazz, "getAssetPath", new Class[0]);
            }
            return getAssetPathMethod;
        }

        @RequiresApi(value=28)
        static Method getGetApkAssetsMethod() throws NoSuchMethodException {
            if (getApkAssetsMethod == null) {
                getApkAssetsMethod = HiddenApiReflection.findMethod(AssetManager.class, "getApkAssets", new Class[0]);
            }
            return getApkAssetsMethod;
        }
    }

    private static class V14
    extends VersionCompat {
        private V14() {
        }

        private static void installSplitResDirs(Context context, Resources preResources, String splitApkPath) throws Throwable {
            String appResDir = context.getPackageResourcePath();
            AssetManager oldAsset = preResources.getAssets();
            List<String> resDirs = V14.getAppResDirs(appResDir, oldAsset);
            resDirs.add(splitApkPath);
            AssetManager newAsset = V14.createAssetManager();
            for (String recent : resDirs) {
                int ret = (Integer)V14.getAddAssetPathMethod().invoke((Object)newAsset, recent);
                if (ret != 0) continue;
                throw new RuntimeException("invoke addAssetPath failure! apk format maybe incorrect");
            }
            V14.getmStringBlocksField().set(newAsset, null);
            V14.getEnsureStringBlocksMethod().invoke((Object)newAsset, new Object[0]);
            V14.getmAssetsField().set(preResources, newAsset);
            V14.clearPreloadTypedArrayIssue(preResources);
            preResources.updateConfiguration(preResources.getConfiguration(), preResources.getDisplayMetrics());
        }

        private static List<String> getAppResDirs(String appResDir, AssetManager asset) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
            AssetManager sysAsset = Resources.getSystem().getAssets();
            Object[] sysStringBlocks = (Object[])V14.getmStringBlocksField().get(sysAsset);
            Object[] appStringBlocks = (Object[])V14.getmStringBlocksField().get(asset);
            int totalResCount = appStringBlocks.length;
            int sysResCount = sysStringBlocks.length;
            ArrayList<String> existedAppResDirList = new ArrayList<String>(totalResCount - sysResCount);
            for (int appResIndex = sysResCount + 1; appResIndex <= totalResCount; ++appResIndex) {
                String inApp = (String)V14.getGetCookieNameMethod().invoke((Object)asset, appResIndex);
                existedAppResDirList.add(inApp);
            }
            if (!existedAppResDirList.contains(appResDir)) {
                boolean inSystem = false;
                for (int i = 1; i <= sysResCount; ++i) {
                    String cookieNameSys = (String)V14.getGetCookieNameMethod().invoke((Object)sysAsset, i);
                    if (!appResDir.equals(cookieNameSys)) continue;
                    inSystem = true;
                    break;
                }
                if (!inSystem) {
                    existedAppResDirList.add(0, appResDir);
                }
            }
            return existedAppResDirList;
        }

        private static void clearPreloadTypedArrayIssue(Resources resources) {
            SplitLog.w((String)SplitCompatResourcesLoader.TAG, (String)"try to clear typedArray cache!", (Object[])new Object[0]);
            try {
                Field typedArrayPoolField = V14.getmTypedArrayPoolField();
                Object origTypedArrayPool = typedArrayPoolField.get(resources);
                Method acquireMethod = HiddenApiReflection.findMethod(origTypedArrayPool, "acquire", new Class[0]);
                while (acquireMethod.invoke(origTypedArrayPool, new Object[0]) != null) {
                }
            }
            catch (Throwable e) {
                SplitLog.e((String)SplitCompatResourcesLoader.TAG, (String)("clearPreloadTypedArrayIssue failed, ignore error: " + e), (Object[])new Object[0]);
            }
        }

        private static AssetManager createAssetManager() throws IllegalAccessException, InstantiationException {
            return (AssetManager)AssetManager.class.newInstance();
        }
    }

    private static class V21
    extends VersionCompat {
        private V21() {
        }

        private static void installSplitResDirs(Resources preResources, String splitFileDir) throws Throwable {
            Method method = VersionCompat.getAddAssetPathMethod();
            method.invoke((Object)preResources.getAssets(), splitFileDir);
        }
    }
}

