/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall.remote;

import com.iqiyi.android.qigsaw.core.common.FileUtil;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitPathManager;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;

final class SplitDeleteRedundantVersionTask
implements Runnable {
    private static final int MAX_SPLIT_CACHE_SIZE = 1;
    private static final String TAG = "SplitDeleteRedundantVersionTask";
    private final Collection<SplitInfo> allSplits;

    SplitDeleteRedundantVersionTask(Collection<SplitInfo> allSplits) {
        this.allSplits = allSplits;
    }

    @Override
    public void run() {
        if (this.allSplits != null) {
            for (SplitInfo splitInfo : this.allSplits) {
                File splitDir = SplitPathManager.require().getSplitDir(splitInfo);
                File splitRootDir = SplitPathManager.require().getSplitRootDir(splitInfo);
                File installedMarkFile = SplitPathManager.require().getSplitMarkFile(splitInfo);
                this.deleteRedundantSplitVersionDirs(splitDir, splitRootDir, installedMarkFile);
            }
        }
    }

    private void deleteRedundantSplitVersionDirs(final File currentSplitVersionDir, File splitRootDir, final File installedMarkFile) {
        final String splitName = splitRootDir.getName();
        File[] files = splitRootDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory() && !pathname.equals(currentSplitVersionDir)) {
                    SplitLog.i((String)SplitDeleteRedundantVersionTask.TAG, (String)"Split %s version %s has been installed!", (Object[])new Object[]{splitName, pathname.getName()});
                    return installedMarkFile.exists();
                }
                return false;
            }
        });
        if (files != null && files.length > 1) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    if (o1.lastModified() < o2.lastModified()) {
                        return 1;
                    }
                    if (o1.lastModified() == o2.lastModified()) {
                        return 0;
                    }
                    return -1;
                }
            });
            for (int i = 1; i < files.length; ++i) {
                SplitLog.i((String)TAG, (String)"Split %s version %s is redundant, so we try to delete it", (Object[])new Object[]{splitName, files[i].getName()});
                FileUtil.deleteDir((File)files[i]);
            }
        }
    }
}

