/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.common.FileUtil;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitPathManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class SplitPendingUninstallManager {
    private static final String TAG = "PendingUninstallSplitsManager";
    private static final String VERSION_DATA_NAME = "uninstallsplits.info";
    private static final String PENDING_UNINSTALL_SPLITS = "pendingUninstallSplits";
    private final File pendingUninstallSplitsFile;
    private static final Object sLock = new Object();

    public SplitPendingUninstallManager() {
        File uninstallDir = SplitPathManager.require().getUninstallSplitsDir();
        this.pendingUninstallSplitsFile = new File(uninstallDir, VERSION_DATA_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readPendingUninstallSplits() {
        Object object = sLock;
        synchronized (object) {
            if (this.pendingUninstallSplitsFile.exists()) {
                return this.readPendingUninstallSplitsInternal(this.pendingUninstallSplitsFile);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deletePendingUninstallSplitsRecord() {
        Object object = sLock;
        synchronized (object) {
            if (this.pendingUninstallSplitsFile.exists()) {
                return FileUtil.deleteFileSafely((File)this.pendingUninstallSplitsFile);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean recordPendingUninstallSplits(@NonNull List<String> pendingUninstallSplits) {
        Object object = sLock;
        synchronized (object) {
            return this.recordPendingUninstallSplitsInternal(this.pendingUninstallSplitsFile, pendingUninstallSplits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readPendingUninstallSplitsInternal(File pendingUninstallSplitsFile) {
        ArrayList uninstallInfoList = null;
        boolean isReadPatchSuccessful = false;
        int numAttempts = 0;
        while (numAttempts < 3 && !isReadPatchSuccessful) {
            ++numAttempts;
            Properties properties = new Properties();
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(pendingUninstallSplitsFile);
                properties.load(inputStream);
                String uninstallSplitsStr = properties.getProperty(PENDING_UNINSTALL_SPLITS);
                if (uninstallSplitsStr != null) {
                    String[] uninstallSplitsArray = uninstallSplitsStr.split(",");
                    uninstallInfoList = new ArrayList();
                    Collections.addAll(uninstallInfoList, uninstallSplitsArray);
                }
                isReadPatchSuccessful = true;
            }
            catch (IOException e) {
                try {
                    SplitLog.w((String)TAG, (String)("read property failed, e:" + e), (Object[])new Object[0]);
                }
                catch (Throwable throwable) {
                    FileUtil.closeQuietly(inputStream);
                    throw throwable;
                }
                FileUtil.closeQuietly((Object)inputStream);
                continue;
            }
            FileUtil.closeQuietly((Object)inputStream);
        }
        return uninstallInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recordPendingUninstallSplitsInternal(File pendingUninstallSplitsFile, List<String> pendingUninstallSplits) {
        List<String> oldPendingUninstallSplits;
        if (pendingUninstallSplitsFile == null || pendingUninstallSplits == null) {
            return false;
        }
        ArrayList<String> tempUninstallSplits = new ArrayList<String>(pendingUninstallSplits);
        SplitLog.i((String)TAG, (String)("recordSplitUninstallInfo file path:" + pendingUninstallSplitsFile.getAbsolutePath() + " , uninstalls splits: " + ((Object)tempUninstallSplits).toString()), (Object[])new Object[0]);
        boolean isWritePatchSuccessful = false;
        int numAttempts = 0;
        if (pendingUninstallSplitsFile.exists() && (oldPendingUninstallSplits = this.readPendingUninstallSplits()) != null) {
            if (oldPendingUninstallSplits.containsAll(tempUninstallSplits)) {
                SplitLog.i((String)TAG, (String)"Splits %s have been marked to uninstall!", (Object[])new Object[]{((Object)tempUninstallSplits).toString()});
                return true;
            }
            tempUninstallSplits.addAll(oldPendingUninstallSplits);
            HashSet<String> tempSet = new HashSet<String>(tempUninstallSplits);
            tempUninstallSplits.clear();
            tempUninstallSplits.addAll(tempSet);
            SplitLog.i((String)TAG, (String)("Splits which need to be uninstalled have been updated, new pending uninstall splits: " + ((Object)tempUninstallSplits).toString()), (Object[])new Object[0]);
        }
        while (numAttempts < 3 && !isWritePatchSuccessful) {
            List<String> tempInfo;
            ++numAttempts;
            Properties newProperties = new Properties();
            newProperties.put(PENDING_UNINSTALL_SPLITS, TextUtils.join((CharSequence)",", tempUninstallSplits));
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(pendingUninstallSplitsFile, false);
                String comment = "splits need to be uninstalled: " + ((Object)tempUninstallSplits).toString();
                newProperties.store(outputStream, comment);
            }
            catch (Exception e) {
                try {
                    SplitLog.w((String)TAG, (String)("write property failed, e:" + e), (Object[])new Object[0]);
                }
                catch (Throwable throwable) {
                    FileUtil.closeQuietly(outputStream);
                    throw throwable;
                }
                FileUtil.closeQuietly((Object)outputStream);
            }
            FileUtil.closeQuietly((Object)outputStream);
            if (isWritePatchSuccessful = (tempInfo = this.readPendingUninstallSplits()) != null && tempInfo.containsAll(tempUninstallSplits)) continue;
            pendingUninstallSplitsFile.delete();
        }
        return isWritePatchSuccessful;
    }
}

