/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall.remote;

import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitApkInstaller;
import com.iqiyi.android.qigsaw.core.splitinstall.protocol.ISplitInstallServiceCallback;
import com.iqiyi.android.qigsaw.core.splitinstall.remote.SplitInstallSupervisor;
import java.util.List;

abstract class DefaultTask
implements Runnable,
SplitInstallSupervisor.Callback {
    private static final String TAG = "Split:DefaultTask";
    final ISplitInstallServiceCallback mCallback;
    private final SplitInstallSupervisor installSupervisor;

    DefaultTask(ISplitInstallServiceCallback callback) {
        this.mCallback = callback;
        this.installSupervisor = SplitApkInstaller.getSplitInstallSupervisor();
    }

    @Override
    public void run() {
        if (this.installSupervisor != null) {
            try {
                this.execute(this.installSupervisor);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.mCallback.onError(SplitInstallSupervisor.bundleErrorCode(-101));
                SplitLog.w((String)TAG, (String)"Have you call Qigsaw#onApplicationCreated method?", (Object[])new Object[0]);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    abstract void execute(@NonNull SplitInstallSupervisor var1) throws RemoteException;

    @Override
    public void onStartInstall(int sessionId, Bundle data) {
    }

    @Override
    public void onDeferredInstall(Bundle data) {
    }

    @Override
    public void onCancelInstall(int sessionId, Bundle data) {
    }

    @Override
    public void onDeferredUninstall(Bundle data) {
    }

    @Override
    public void onError(Bundle data) {
        try {
            this.mCallback.onError(data);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onGetSession(int sessionId, Bundle data) {
    }

    @Override
    public void onGetSessionStates(List<Bundle> data) {
    }
}

