/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import android.content.Intent;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallInternalSessionState;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallReporterManager;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallSessionManager;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallTask;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstaller;
import com.iqiyi.android.qigsaw.core.splitreport.SplitInstallError;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

final class SplitStartInstallTask
extends SplitInstallTask {
    private final SplitInstallSessionManager mSessionManager;
    private final SplitInstallInternalSessionState mSessionState;

    SplitStartInstallTask(int sessionId, SplitInstaller installer, SplitInstallSessionManager sessionManager, List<String> moduleNames, List<SplitInfo> splitInfoList) {
        super(installer, moduleNames, splitInfoList);
        this.mSessionState = sessionManager.getSessionState(sessionId);
        this.mSessionManager = sessionManager;
    }

    @Override
    boolean continueInstallIgnoreError() {
        return false;
    }

    @Override
    protected void onPreInstall() {
        super.onPreInstall();
        this.mSessionManager.changeSessionState(this.mSessionState.sessionId(), 4);
        this.emitSessionStatus();
    }

    @Override
    protected void onInstallCompleted(List<SplitInstaller.InstallResult> installResults, long cost) {
        ArrayList<Intent> splitFileIntents = new ArrayList<Intent>(installResults.size());
        for (SplitInstaller.InstallResult installResult : installResults) {
            Intent splitFileIntent = new Intent();
            if (installResult.libFile != null) {
                splitFileIntent.putExtra("native-libraries", installResult.libFile.getAbsolutePath());
            }
            if (installResult.multiDexFiles != null) {
                splitFileIntent.putStringArrayListExtra("multi-dex", this.getDexFilePaths(installResult.multiDexFiles));
            }
            if (installResult.optDir != null) {
                splitFileIntent.putExtra("optimized-directory", installResult.optDir.getAbsolutePath());
            }
            splitFileIntent.putExtra("splitDir", installResult.splitDir.getAbsolutePath());
            splitFileIntent.putExtra("apk", installResult.apkFile.getAbsolutePath());
            splitFileIntent.putExtra("splitName", installResult.splitName);
            splitFileIntents.add(splitFileIntent);
        }
        this.mSessionState.setSplitFileIntents(splitFileIntents);
        this.mSessionManager.changeSessionState(this.mSessionState.sessionId(), 10);
        this.emitSessionStatus();
        if (SplitInstallReporterManager.getInstallReporter() != null) {
            SplitInstallReporterManager.getInstallReporter().onStartInstallOK(this.moduleNames, cost);
        }
    }

    @Override
    protected void onInstallFailed(List<SplitInstallError> errors, long cost) {
        this.mSessionState.setErrorCode(errors.get(0).getErrorCode());
        this.mSessionManager.changeSessionState(this.mSessionState.sessionId(), 6);
        this.emitSessionStatus();
        if (SplitInstallReporterManager.getInstallReporter() != null) {
            SplitInstallReporterManager.getInstallReporter().onStartInstallFailed(this.moduleNames, errors.get(0), cost);
        }
    }

    private void emitSessionStatus() {
        this.mSessionManager.emitSessionState(this.mSessionState);
    }

    private ArrayList<String> getDexFilePaths(List<File> dexFiles) {
        ArrayList<String> dexFilePaths = new ArrayList<String>(dexFiles.size());
        for (File dexFile : dexFiles) {
            dexFilePaths.add(dexFile.getAbsolutePath());
        }
        return dexFilePaths;
    }
}

