/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import android.os.Build;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import java.io.File;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SplitInstallerInternals {
    private static String currentInstructionSet = null;

    private SplitInstallerInternals() {
    }

    static boolean isVMMultiDexCapable(String versionString) {
        Matcher matcher;
        boolean isMultiDexCapable = false;
        if (versionString != null && (matcher = Pattern.compile("(\\d+)\\.(\\d+)(\\.\\d+)?").matcher(versionString)).matches()) {
            try {
                int major = Integer.parseInt(matcher.group(1));
                int minor = Integer.parseInt(matcher.group(2));
                isMultiDexCapable = major > 2 || major == 2 && minor >= 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        SplitLog.i((String)"Split:MultiDex", (String)("VM with version " + versionString + (isMultiDexCapable ? " has multidex support" : " does not have multidex support")), (Object[])new Object[0]);
        return isMultiDexCapable;
    }

    static String optimizedPathFor(File path, File optimizedDirectory) {
        if (Build.VERSION.SDK_INT >= 26) {
            String currentInstructionSet;
            try {
                currentInstructionSet = SplitInstallerInternals.getCurrentInstructionSet();
            }
            catch (Exception e) {
                throw new RuntimeException("getCurrentInstructionSet fail:", e);
            }
            File parentFile = path.getParentFile();
            String fileName = path.getName();
            int index = fileName.lastIndexOf(46);
            if (index > 0) {
                fileName = fileName.substring(0, index);
            }
            return parentFile.getAbsolutePath() + "/oat/" + currentInstructionSet + "/" + fileName + ".odex";
        }
        String fileName = path.getName();
        if (!fileName.endsWith(".dex")) {
            int lastDot = fileName.lastIndexOf(".");
            if (lastDot < 0) {
                fileName = fileName + ".dex";
            } else {
                StringBuilder sb = new StringBuilder(lastDot + 4);
                sb.append(fileName, 0, lastDot);
                sb.append(".dex");
                fileName = sb.toString();
            }
        }
        File result = new File(optimizedDirectory, fileName);
        return result.getPath();
    }

    private static String getCurrentInstructionSet() throws Exception {
        if (currentInstructionSet != null) {
            return currentInstructionSet;
        }
        Class<?> clazz = Class.forName("dalvik.system.VMRuntime");
        Method currentGet = clazz.getDeclaredMethod("getCurrentInstructionSet", new Class[0]);
        currentInstructionSet = (String)currentGet.invoke(null, new Object[0]);
        return currentInstructionSet;
    }

    static boolean shouldAcceptEvenIfOptFileIllegal(File file) {
        return !(!"vivo".equalsIgnoreCase(Build.MANUFACTURER) && !"oppo".equalsIgnoreCase(Build.MANUFACTURER) || file.exists() && file.length() != 0L);
    }
}

