/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import android.content.Context;
import android.os.Build;
import com.iqiyi.android.qigsaw.core.common.FileUtil;
import com.iqiyi.android.qigsaw.core.common.SplitBaseInfoProvider;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitinstall.SignatureValidator;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitElfFile;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstaller;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstallerInternals;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitLibExtractor;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitMultiDexExtractor;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitPathManager;
import dalvik.system.DexFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class SplitInstallerImpl
extends SplitInstaller {
    private static final boolean IS_VM_MULTIDEX_CAPABLE = SplitInstallerInternals.isVMMultiDexCapable(System.getProperty("java.vm.version"));
    private static final String TAG = "Split:SplitInstallerImpl";
    private final Context mContext;

    SplitInstallerImpl(Context context) {
        this.mContext = context;
    }

    @Override
    public SplitInstaller.InstallResult install(SplitInfo info) throws SplitInstaller.InstallException {
        File splitDir = SplitPathManager.require().getSplitDir(info);
        File sourceApk = new File(splitDir, info.getSplitName() + ".apk");
        this.validateSignature(sourceApk);
        File libDir = null;
        if (this.isLibExtractNeeded(info)) {
            libDir = this.extractLib(info, sourceApk);
        }
        List<File> multiDexFiles = null;
        File optimizedDir = null;
        if (info.hasDex()) {
            List<File> dexFiles;
            if (!this.isVMMultiDexCapable() && this.isMultiDexExtractNeeded(info)) {
                multiDexFiles = this.extractMultiDex(info, sourceApk);
            }
            if (multiDexFiles == null || multiDexFiles.isEmpty()) {
                dexFiles = Collections.singletonList(sourceApk);
            } else {
                dexFiles = new ArrayList<File>(multiDexFiles);
                dexFiles.add(sourceApk);
            }
            optimizedDir = SplitPathManager.require().getSplitOptDir(info);
            List<File> optDexFiles = this.getOptimizedDexFiles(dexFiles, optimizedDir);
            if (this.isOptimizeDexNeeded(optDexFiles)) {
                this.deleteCorruptedFiles(optDexFiles);
                List<DexFile> dexes = this.optimizeDex(dexFiles, optimizedDir);
                this.checkOptimizedDexFiles(optDexFiles, dexes);
            }
        }
        this.createInstalledMark(info);
        return new SplitInstaller.InstallResult(info.getSplitName(), splitDir, sourceApk, optimizedDir, libDir, multiDexFiles);
    }

    @Override
    protected void validateSignature(File splitApk) throws SplitInstaller.InstallException {
        if (!FileUtil.isLegalFile((File)splitApk)) {
            throw new SplitInstaller.InstallException(-11, new FileNotFoundException("Split apk " + splitApk.getAbsolutePath() + " is illegal!"));
        }
        if (!SignatureValidator.validateSplit(this.mContext, splitApk)) {
            this.deleteCorruptedFiles(Collections.singletonList(splitApk));
            throw new SplitInstaller.InstallException(-12, new SignatureException("Failed to check split apk " + splitApk.getAbsolutePath() + " signature!"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List<File> extractMultiDex(SplitInfo info, File splitApk) throws SplitInstaller.InstallException {
        SplitLog.w((String)TAG, (String)"VM do not support multi-dex, but split %s has multi dex files, so we need creteSplitInstallService other dex files manually", (Object[])new Object[]{splitApk.getName()});
        File codeCacheDir = SplitPathManager.require().getSplitCodeCacheDir(info);
        String prefsKeyPrefix = info.getSplitName() + "@" + SplitBaseInfoProvider.getVersionName() + "@" + info.getSplitVersion();
        try {
            SplitMultiDexExtractor extractor = new SplitMultiDexExtractor(splitApk, codeCacheDir);
            try {
                List<File> dexFiles = extractor.load(this.mContext, prefsKeyPrefix, false);
                SplitLog.w((String)TAG, (String)"Succeed to load or extract dex files", (Object[])new Object[]{dexFiles.toString()});
                List<File> list = dexFiles;
                return list;
            }
            catch (IOException e) {
                SplitLog.w((String)TAG, (String)"Failed to load or extract dex files", (Throwable)e);
                throw new SplitInstaller.InstallException(-13, e);
            }
            finally {
                FileUtil.closeQuietly((Object)extractor);
            }
        }
        catch (IOException ioError) {
            throw new SplitInstaller.InstallException(-13, ioError);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected File extractLib(SplitInfo info, File sourceApk) throws SplitInstaller.InstallException {
        try {
            File splitLibDir = SplitPathManager.require().getSplitLibDir(info);
            SplitLibExtractor extractor = new SplitLibExtractor(sourceApk, splitLibDir);
            try {
                List<File> libFiles = extractor.load(info, false);
                SplitLog.i((String)TAG, (String)"Succeed to extract libs:  %s", (Object[])new Object[]{libFiles.toString()});
                File file = splitLibDir;
                return file;
            }
            catch (IOException e) {
                SplitLog.w((String)TAG, (String)"Failed to load or extract lib files", (Throwable)e);
                throw new SplitInstaller.InstallException(-14, e);
            }
            finally {
                FileUtil.closeQuietly((Object)extractor);
            }
        }
        catch (IOException ioError) {
            throw new SplitInstaller.InstallException(-14, ioError);
        }
    }

    @Override
    protected List<DexFile> optimizeDex(List<File> dexFiles, File optimizedDir) throws SplitInstaller.InstallException {
        ArrayList<DexFile> dexes = new ArrayList<DexFile>(dexFiles.size());
        for (File dexFile : dexFiles) {
            SplitInstaller.DexOptimizer optimizer = new SplitInstaller.DexOptimizer(dexFile, optimizedDir);
            try {
                DexFile dex = optimizer.optimize();
                dexes.add(dex);
            }
            catch (IOException e) {
                throw new SplitInstaller.InstallException(-15, e);
            }
        }
        return dexes;
    }

    @Override
    protected void checkOptimizedDexFiles(List<File> optFiles, List<DexFile> dexFiles) throws SplitInstaller.InstallException {
        if (!this.waitForDexOptimize(optFiles)) {
            this.deleteCorruptedFiles(optFiles);
            this.closeDexFileQuietly(dexFiles);
            throw new SplitInstaller.InstallException(-16, new IOException("Failed to check opt files " + dexFiles.toString()));
        }
    }

    @Override
    protected void createInstalledMark(SplitInfo info) throws SplitInstaller.InstallException {
        File splitDir = SplitPathManager.require().getSplitDir(info);
        File markFile = new File(splitDir, info.getMd5());
        if (!markFile.exists()) {
            boolean isCreationSuccessful = false;
            int numAttempts = 0;
            Exception cause = null;
            while (numAttempts < 3 && !isCreationSuccessful) {
                ++numAttempts;
                try {
                    if (!markFile.createNewFile()) {
                        SplitLog.w((String)TAG, (String)"Split %s mark file %s already exists", (Object[])new Object[]{info.getSplitName(), markFile.getAbsolutePath()});
                    }
                    isCreationSuccessful = true;
                }
                catch (Exception e) {
                    isCreationSuccessful = false;
                    cause = e;
                }
            }
            if (!isCreationSuccessful) {
                throw new SplitInstaller.InstallException(-17, cause);
            }
        }
    }

    @Override
    protected Context getApplicationContext() {
        return this.mContext;
    }

    private boolean waitForDexOptimize(List<File> optFiles) {
        int size = optFiles.size() * 30;
        if (size > 120) {
            size = 120;
        }
        for (int i = 0; i < size; ++i) {
            if (this.checkAllDexOptFileExisting(optFiles, i)) continue;
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException e) {
                SplitLog.e((String)TAG, (String)"thread sleep InterruptedException", (Throwable)e);
            }
        }
        return this.checkOptimizedDexFilesValid(optFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkOptimizedDexFilesValid(List<File> optFiles) {
        ArrayList<File> failedOptFiles = new ArrayList<File>();
        for (File file : optFiles) {
            if (FileUtil.isLegalFile((File)file) || SplitInstallerInternals.shouldAcceptEvenIfOptFileIllegal(file)) continue;
            SplitLog.e((String)TAG, (String)"final parallel dex optimizer file %s is not exist, return false", (Object[])new Object[]{file.getName()});
            failedOptFiles.add(file);
        }
        if (!failedOptFiles.isEmpty()) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Throwable lastThrowable = null;
            for (File file : optFiles) {
                int retType;
                if (SplitInstallerInternals.shouldAcceptEvenIfOptFileIllegal(file)) continue;
                try {
                    retType = SplitElfFile.getFileTypeByMagic(file);
                }
                catch (IOException e) {
                    continue;
                }
                if (retType != 1) continue;
                SplitElfFile elfFile = null;
                try {
                    elfFile = new SplitElfFile(file);
                    SplitLog.i((String)TAG, (String)"Succeed to check oat file format!", (Object[])new Object[0]);
                }
                catch (Throwable e) {
                    try {
                        SplitLog.e((String)TAG, (String)"final parallel dex optimizer file %s is not elf format", (Object[])new Object[]{file.getName()});
                        failedOptFiles.add(file);
                        lastThrowable = e;
                    }
                    catch (Throwable throwable) {
                        FileUtil.closeQuietly(elfFile);
                        throw throwable;
                    }
                    FileUtil.closeQuietly((Object)elfFile);
                    continue;
                }
                FileUtil.closeQuietly((Object)elfFile);
            }
            if (!failedOptFiles.isEmpty()) {
                SplitLog.e((String)TAG, (String)("Failed to opt dex file " + optFiles.toString()), lastThrowable);
                this.deleteCorruptedFiles(failedOptFiles);
                return false;
            }
        }
        return true;
    }

    private boolean isVMMultiDexCapable() {
        return IS_VM_MULTIDEX_CAPABLE;
    }

    private boolean isMultiDexExtractNeeded(SplitInfo info) {
        return info.isMultiDex();
    }

    private boolean isLibExtractNeeded(SplitInfo info) {
        return info.hasLibs();
    }

    private List<File> getOptimizedDexFiles(List<File> dexFiles, File optimizedDir) {
        ArrayList<File> optFiles = new ArrayList<File>();
        for (File dexFile : dexFiles) {
            String optimizedPath = SplitInstallerInternals.optimizedPathFor(dexFile, optimizedDir);
            optFiles.add(new File(optimizedPath));
        }
        return optFiles;
    }

    private boolean isOptimizeDexNeeded(List<File> optFiles) {
        for (File optFile : optFiles) {
            if (optFile.exists()) continue;
            return true;
        }
        return !this.checkOptimizedDexFilesValid(optFiles);
    }

    private void deleteCorruptedFiles(List<File> files) {
        for (File file : files) {
            FileUtil.safeDeleteFile((File)file);
        }
    }

    private boolean checkAllDexOptFileExisting(List<File> files, int count) {
        for (File file : files) {
            if (FileUtil.isLegalFile((File)file) || SplitInstallerInternals.shouldAcceptEvenIfOptFileIllegal(file)) continue;
            SplitLog.e((String)TAG, (String)"parallel dex optimizer file %s is not exist, just wait %d times", (Object[])new Object[]{file.getName(), count});
            return false;
        }
        return true;
    }

    private void closeDexFileQuietly(List<DexFile> dexFiles) {
        for (DexFile dex : dexFiles) {
            if (dex == null) continue;
            try {
                dex.close();
            }
            catch (Exception exception) {}
        }
    }
}

