/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.split.signature.G;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class SignatureValidator {
    private static final String TAG = "SignatureValidator";

    private SignatureValidator() {
    }

    static boolean validateSplit(Context context, File splitFile) {
        ArrayList<X509Certificate> signatureList;
        Signature[] signatures = SignatureValidator.getAppSignature(context);
        if (signatures == null) {
            signatureList = null;
        } else {
            ArrayList<X509Certificate> temp = new ArrayList<X509Certificate>();
            for (Signature signature : signatures) {
                X509Certificate x509Certificate = SignatureValidator.decodeCertificate(signature);
                if (x509Certificate == null) continue;
                temp.add(x509Certificate);
            }
            signatureList = temp;
        }
        if (signatureList != null && !signatureList.isEmpty()) {
            return SignatureValidator.a(splitFile.getAbsolutePath(), (List<X509Certificate>)signatureList);
        }
        return false;
    }

    private static boolean a(String var1, List<X509Certificate> var2) {
        X509Certificate[][] var3;
        try {
            var3 = G.a(var1);
        }
        catch (Exception var14) {
            SplitLog.e((String)TAG, (String)new StringBuilder(32 + String.valueOf(var1).length()).append("Downloaded split ").append(var1).append(" is not signed.").toString(), (Throwable)var14);
            return false;
        }
        if (var3 != null && var3.length != 0 && var3[0].length != 0) {
            boolean var9;
            X509Certificate[][] var5 = var3;
            if (var2.isEmpty()) {
                SplitLog.e((String)TAG, (String)"No certificates found for app.", (Object[])new Object[0]);
                return false;
            }
            Iterator<X509Certificate> var7 = var2.iterator();
            block2: do {
                if (!var7.hasNext()) {
                    return true;
                }
                X509Certificate var8 = var7.next();
                var9 = false;
                X509Certificate[][] var10 = var5;
                int var11 = var5.length;
                for (int var12 = 0; var12 < var11; ++var12) {
                    if (!var10[var12][0].equals(var8)) continue;
                    var9 = true;
                    continue block2;
                }
            } while (var9);
            SplitLog.i((String)TAG, (String)"There's an app certificate that doesn't sign the split.", (Object[])new Object[0]);
            return false;
        }
        SplitLog.e((String)TAG, (String)new StringBuilder(32 + String.valueOf(var1).length()).append("Downloaded split ").append(var1).append(" is not signed.").toString(), (Object[])new Object[0]);
        return false;
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    private static Signature[] getAppSignature(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)64).signatures;
        }
        catch (PackageManager.NameNotFoundException var1) {
            return null;
        }
    }

    private static X509Certificate decodeCertificate(Signature var0) {
        try {
            return (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(var0.toByteArray()));
        }
        catch (CertificateException var2) {
            SplitLog.e((String)TAG, (String)"Cannot decode certificate.", (Throwable)var2);
            return null;
        }
    }
}

