/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import android.app.Activity;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.view.View;
import android.widget.TextView;
import com.iqiyi.android.qigsaw.core.splitinstall.R;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitApkInstaller;
import com.iqiyi.android.qigsaw.core.splitinstall.remote.SplitInstallSupervisor;
import java.text.DecimalFormat;
import java.util.ArrayList;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ObtainUserConfirmationActivity
extends Activity {
    private boolean fromUserClick;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_obtain_user_confirmation);
        this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.getWindow().setLayout(-1, -2);
        this.setFinishOnTouchOutside(false);
        final int sessionId = this.getIntent().getIntExtra("sessionId", 0);
        final ArrayList downloadRequests = this.getIntent().getParcelableArrayListExtra("downloadRequests");
        long realTotalBytesNeedToDownload = this.getIntent().getLongExtra("realTotalBytesNeedToDownload", 0L);
        final SplitInstallSupervisor installService = SplitApkInstaller.getSplitInstallSupervisor(this.getApplicationContext());
        if (sessionId == 0 || downloadRequests == null || realTotalBytesNeedToDownload <= 0L || installService == null) {
            this.finish();
        } else {
            TextView descText = (TextView)this.findViewById(R.id.user_conformation_tv);
            DecimalFormat df = new DecimalFormat("#.00");
            double convert = (float)realTotalBytesNeedToDownload / 1048576.0f;
            descText.setText((CharSequence)String.format(this.getString(R.string.prompt_desc), df.format(convert)));
            this.findViewById(R.id.user_confirm).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ObtainUserConfirmationActivity.this.fromUserClick) {
                        return;
                    }
                    ObtainUserConfirmationActivity.this.fromUserClick = true;
                    installService.continueInstallWithUserConfirmation(sessionId, downloadRequests);
                    ObtainUserConfirmationActivity.this.setResult(-1);
                    ObtainUserConfirmationActivity.this.finish();
                }
            });
            this.findViewById(R.id.user_cancel).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ObtainUserConfirmationActivity.this.fromUserClick) {
                        return;
                    }
                    ObtainUserConfirmationActivity.this.fromUserClick = true;
                    installService.cancelInstallWithoutUserConfirmation(sessionId);
                    ObtainUserConfirmationActivity.this.setResult(0);
                    ObtainUserConfirmationActivity.this.finish();
                }
            });
        }
    }
}

