/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitinstall;

import com.iqiyi.android.qigsaw.core.common.SplitLog;
import com.iqiyi.android.qigsaw.core.splitinstall.SplitInstaller;
import com.iqiyi.android.qigsaw.core.splitreport.SplitInstallError;
import com.iqiyi.android.qigsaw.core.splitrequest.splitinfo.SplitInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

abstract class SplitInstallTask
implements Runnable {
    private static final String TAG = "SplitInstallTask";
    private final SplitInstaller installer;
    private final Collection<SplitInfo> needUpdateSplits;
    final List<String> moduleNames;

    SplitInstallTask(SplitInstaller installer, List<String> moduleNames, Collection<SplitInfo> needUpdateSplits) {
        this.installer = installer;
        this.moduleNames = moduleNames;
        this.needUpdateSplits = needUpdateSplits;
    }

    abstract boolean continueInstallIgnoreError();

    @Override
    public final void run() {
        this.onPreInstall();
        long currentTime = System.currentTimeMillis();
        ArrayList<SplitInstaller.InstallResult> installResults = new ArrayList<SplitInstaller.InstallResult>();
        ArrayList<SplitInstallError> installErrors = new ArrayList<SplitInstallError>(0);
        boolean installCompleted = true;
        for (SplitInfo info : this.needUpdateSplits) {
            try {
                SplitInstaller.InstallResult installResult = this.installer.install(info);
                installResults.add(installResult);
            }
            catch (SplitInstaller.InstallException error) {
                SplitLog.printErrStackTrace((String)TAG, (Throwable)error, (String)("Failed to install split " + info.getSplitName()), (Object[])new Object[0]);
                installCompleted = false;
                installErrors.add(new SplitInstallError(info.getSplitName(), error.getErrorCode(), error.getCause()));
                if (this.continueInstallIgnoreError()) continue;
                break;
            }
        }
        if (installCompleted) {
            this.onInstallCompleted(installResults, System.currentTimeMillis() - currentTime);
        } else {
            this.onInstallFailed(installErrors, System.currentTimeMillis() - currentTime);
        }
    }

    protected void onPreInstall() {
    }

    abstract void onInstallCompleted(List<SplitInstaller.InstallResult> var1, long var2);

    abstract void onInstallFailed(List<SplitInstallError> var1, long var2);
}

