/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.common.FileUtil;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AbiUtil {
    private static final String TAG = "Split:AbiUtil";
    private static final String armv5 = "armeabi";
    private static final String armv7 = "armeabi-v7a";
    private static final String armv8 = "arm64-v8a";
    private static final String x86 = "x86";
    private static final String x86_64 = "x86_64";
    private static AtomicReference<String> basePrimaryAbi = new AtomicReference();
    private static AtomicReference<String> currentInstructionSet = new AtomicReference();

    private static List<String> getSupportedAbis() {
        List<String> supportedAbis = Build.VERSION.SDK_INT >= 21 ? Arrays.asList(Build.SUPPORTED_ABIS) : Arrays.asList(Build.CPU_ABI, Build.CPU_ABI2);
        return supportedAbis;
    }

    @SuppressLint(value={"DiscouragedPrivateApi"})
    private static String getCurrentInstructionSet() {
        if (!TextUtils.isEmpty((CharSequence)currentInstructionSet.get())) {
            return currentInstructionSet.get();
        }
        try {
            Class<?> clazz = Class.forName("dalvik.system.VMRuntime");
            Method currentGet = clazz.getDeclaredMethod("getCurrentInstructionSet", new Class[0]);
            currentGet.setAccessible(true);
            currentInstructionSet.compareAndSet(null, (String)currentGet.invoke(null, new Object[0]));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return currentInstructionSet.get();
    }

    private static String findPrimaryAbiFromCurrentInstructionSet(String currentInstructionSet) {
        if (TextUtils.isEmpty((CharSequence)currentInstructionSet)) {
            return null;
        }
        switch (currentInstructionSet) {
            case "x86": {
                return x86;
            }
            case "x86_64": {
                return x86_64;
            }
            case "arm64": {
                return armv8;
            }
        }
        return null;
    }

    private static String findPrimaryAbiFromProperties(Context context) {
        try {
            InputStream is = context.getAssets().open("base.app.cpu.abilist.properties");
            Properties properties = new Properties();
            properties.load(is);
            String abis = properties.getProperty("abiList");
            if (!TextUtils.isEmpty((CharSequence)abis)) {
                String[] abiArray = abis.split(",");
                HashSet<String> abiList = new HashSet<String>();
                Collections.addAll(abiList, abiArray);
                if (!abiList.isEmpty()) {
                    Set<String> sortedAbis = AbiUtil.sortAbis(abiList);
                    SplitLog.i(TAG, "sorted abis: " + sortedAbis, new Object[0]);
                    return AbiUtil.findBasePrimaryAbi(sortedAbis);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findPrimaryAbiFromBaseApk(Context context) {
        String baseApk = context.getApplicationInfo().sourceDir;
        ZipFile zipFile = null;
        HashSet<String> apkSupportedAbis = new HashSet<String>();
        try {
            zipFile = new ZipFile(baseApk);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                String[] abiDirNames;
                ZipEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (entryName.charAt(0) < 'l' || entryName.charAt(0) > 'l' || !entryName.startsWith("lib/") || !entryName.endsWith(".so") || (abiDirNames = entryName.split("/")).length != 3) continue;
                apkSupportedAbis.add(abiDirNames[1]);
            }
        }
        catch (IOException e) {
            SplitLog.w(TAG, "Failed to open base apk " + baseApk, e);
        }
        finally {
            if (zipFile != null) {
                FileUtil.closeQuietly(zipFile);
            }
        }
        Set<String> sortedAbis = AbiUtil.sortAbis(apkSupportedAbis);
        SplitLog.i(TAG, "sorted abis: " + sortedAbis, new Object[0]);
        return AbiUtil.findBasePrimaryAbi(sortedAbis);
    }

    private static Set<String> sortAbis(Set<String> abis) {
        if (abis.isEmpty() || abis.size() == 1) {
            return abis;
        }
        HashSet<String> ret = new HashSet<String>(abis.size());
        if (abis.contains(armv8)) {
            ret.add(armv8);
        }
        if (abis.contains(armv7)) {
            ret.add(armv7);
        }
        if (abis.contains(armv5)) {
            ret.add(armv5);
        }
        if (abis.contains(x86)) {
            ret.add(x86);
        }
        if (abis.contains(x86_64)) {
            ret.add(x86_64);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBasePrimaryAbi(@NonNull Context context) {
        if (!TextUtils.isEmpty((CharSequence)basePrimaryAbi.get())) {
            return basePrimaryAbi.get();
        }
        Class<AbiUtil> clazz = AbiUtil.class;
        synchronized (AbiUtil.class) {
            ApplicationInfo info = context.getApplicationInfo();
            try {
                Field primaryCpuAbi_Field = ApplicationInfo.class.getField("primaryCpuAbi");
                primaryCpuAbi_Field.setAccessible(true);
                basePrimaryAbi.compareAndSet(null, (String)primaryCpuAbi_Field.get(info));
                SplitLog.i(TAG, "Succeed to get primaryCpuAbi %s from ApplicationInfo.", basePrimaryAbi);
            }
            catch (Throwable e) {
                SplitLog.w(TAG, "Failed to get primaryCpuAbi from ApplicationInfo.", e);
            }
            if (TextUtils.isEmpty((CharSequence)basePrimaryAbi.get())) {
                String currentInstructionSet = AbiUtil.getCurrentInstructionSet();
                basePrimaryAbi.compareAndSet(null, AbiUtil.findPrimaryAbiFromCurrentInstructionSet(currentInstructionSet));
                if (TextUtils.isEmpty((CharSequence)basePrimaryAbi.get())) {
                    SplitLog.w(TAG, "Failed to get primaryCpuAbi from CurrentInstructionSet.", new Object[0]);
                    basePrimaryAbi.compareAndSet(null, AbiUtil.findPrimaryAbiFromProperties(context));
                    if (TextUtils.isEmpty((CharSequence)basePrimaryAbi.get())) {
                        SplitLog.i(TAG, "Failed to get primaryCpuAbi from Properties.", new Object[0]);
                        basePrimaryAbi.compareAndSet(null, AbiUtil.findPrimaryAbiFromBaseApk(context));
                        SplitLog.i(TAG, "Succeed to get primaryCpuAbi %s from BaseApk.", basePrimaryAbi);
                    } else {
                        SplitLog.i(TAG, "Succeed to get primaryCpuAbi %s from Properties.", basePrimaryAbi);
                    }
                } else {
                    SplitLog.i(TAG, "Succeed to get primaryCpuAbi %s from CurrentInstructionSet.", basePrimaryAbi);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return basePrimaryAbi.get();
        }
    }

    private static String findBasePrimaryAbi(Collection<String> sortedAbis) {
        List<String> supportedAbis = AbiUtil.getSupportedAbis();
        if (sortedAbis == null || sortedAbis.isEmpty()) {
            return supportedAbis.get(0);
        }
        for (String abi : supportedAbis) {
            if (!sortedAbis.contains(abi)) continue;
            return abi;
        }
        throw new RuntimeException(String.format("No supported abi for this device, supported abis: %s, sorted abis: %s", supportedAbis.toString(), sortedAbis.toString()));
    }

    public static String findSplitPrimaryAbi(@NonNull String basePrimaryAbi, @NonNull List<String> splitAbis) {
        if (splitAbis.contains(basePrimaryAbi)) {
            return basePrimaryAbi;
        }
        if (basePrimaryAbi.equals(armv8)) {
            return splitAbis.contains(armv8) ? armv8 : null;
        }
        if (basePrimaryAbi.equals(x86_64)) {
            return splitAbis.contains(x86_64) ? x86_64 : null;
        }
        if (basePrimaryAbi.equals(x86)) {
            if (splitAbis.contains(x86)) {
                return x86;
            }
            if (splitAbis.contains(armv5)) {
                return armv5;
            }
        } else if (basePrimaryAbi.equals(armv7)) {
            if (splitAbis.contains(armv7)) {
                return armv7;
            }
            if (splitAbis.contains(armv5)) {
                return armv5;
            }
        } else if (basePrimaryAbi.equals(armv5)) {
            if (splitAbis.contains(armv5)) {
                return armv5;
            }
            List<String> supportedAbis = AbiUtil.getSupportedAbis();
            if (supportedAbis.contains(armv7) && splitAbis.contains(armv7)) {
                return armv7;
            }
        }
        return null;
    }
}

