/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.common;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

class SplitElfFile
implements Closeable {
    public static final int FILE_TYPE_OTHERS = -1;
    public static final int FILE_TYPE_ODEX = 0;
    public static final int FILE_TYPE_ELF = 1;
    private final FileInputStream fis;
    private final Map<String, SectionHeader> sectionNameToHeaderMap = new HashMap<String, SectionHeader>();
    public ElfHeader elfHeader;
    public ProgramHeader[] programHeaders;
    public SectionHeader[] sectionHeaders;

    public SplitElfFile(File file) throws IOException {
        int i;
        this.fis = new FileInputStream(file);
        FileChannel channel = this.fis.getChannel();
        this.elfHeader = new ElfHeader(channel);
        ByteBuffer headerBuffer = ByteBuffer.allocate(128);
        headerBuffer.limit(this.elfHeader.ePhEntSize);
        headerBuffer.order(this.elfHeader.eIndent[5] == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        channel.position(this.elfHeader.ePhOff);
        this.programHeaders = new ProgramHeader[this.elfHeader.ePhNum];
        for (i = 0; i < this.programHeaders.length; ++i) {
            SplitElfFile.readUntilLimit(channel, headerBuffer, "failed to read phdr.");
            this.programHeaders[i] = new ProgramHeader(headerBuffer, this.elfHeader.eIndent[4]);
        }
        channel.position(this.elfHeader.eShOff);
        headerBuffer.limit(this.elfHeader.eShEntSize);
        this.sectionHeaders = new SectionHeader[this.elfHeader.eShNum];
        for (i = 0; i < this.sectionHeaders.length; ++i) {
            SplitElfFile.readUntilLimit(channel, headerBuffer, "failed to read shdr.");
            this.sectionHeaders[i] = new SectionHeader(headerBuffer, this.elfHeader.eIndent[4]);
        }
        if (this.elfHeader.eShStrNdx > 0) {
            SectionHeader shStrTabSectionHeader = this.sectionHeaders[this.elfHeader.eShStrNdx];
            ByteBuffer shStrTab = this.getSection(shStrTabSectionHeader);
            for (SectionHeader shdr : this.sectionHeaders) {
                shStrTab.position(shdr.shName);
                shdr.shNameStr = SplitElfFile.readCString(shStrTab);
                this.sectionNameToHeaderMap.put(shdr.shNameStr, shdr);
            }
        }
    }

    private static void assertInRange(int b, int lb, int ub, String errMsg) throws IOException {
        if (b < lb || b > ub) {
            throw new IOException(errMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getFileTypeByMagic(File file) throws IOException {
        InputStream is = null;
        try {
            byte[] magicBuf = new byte[4];
            is = new FileInputStream(file);
            is.read(magicBuf);
            if (magicBuf[0] == 100 && magicBuf[1] == 101 && magicBuf[2] == 121 && magicBuf[3] == 10) {
                int n = 0;
                return n;
            }
            if (magicBuf[0] == 127 && magicBuf[1] == 69 && magicBuf[2] == 76 && magicBuf[3] == 70) {
                int n = 1;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static void readUntilLimit(FileChannel channel, ByteBuffer bufferOut, String errMsg) throws IOException {
        bufferOut.rewind();
        int bytesRead = channel.read(bufferOut);
        if (bytesRead != bufferOut.limit()) {
            throw new IOException(errMsg + " Rest bytes insufficient, expect to read " + bufferOut.limit() + " bytes but only " + bytesRead + " bytes were read.");
        }
        bufferOut.flip();
    }

    public static String readCString(ByteBuffer buffer) {
        byte[] rawBuffer = buffer.array();
        int begin = buffer.position();
        while (buffer.hasRemaining() && rawBuffer[buffer.position()] != 0) {
            buffer.position(buffer.position() + 1);
        }
        buffer.position(buffer.position() + 1);
        return new String(rawBuffer, begin, buffer.position() - begin - 1, Charset.forName("ASCII"));
    }

    public FileChannel getChannel() {
        return this.fis.getChannel();
    }

    public boolean is32BitElf() {
        return this.elfHeader.eIndent[4] == 1;
    }

    public ByteOrder getDataOrder() {
        return this.elfHeader.eIndent[5] == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public SectionHeader getSectionHeaderByName(String name) {
        return this.sectionNameToHeaderMap.get(name);
    }

    public ByteBuffer getSection(SectionHeader sectionHeader) throws IOException {
        ByteBuffer result = ByteBuffer.allocate((int)sectionHeader.shSize);
        this.fis.getChannel().position(sectionHeader.shOffset);
        SplitElfFile.readUntilLimit(this.fis.getChannel(), result, "failed to read section: " + sectionHeader.shNameStr);
        return result;
    }

    public ByteBuffer getSegment(ProgramHeader programHeader) throws IOException {
        ByteBuffer result = ByteBuffer.allocate((int)programHeader.pFileSize);
        this.fis.getChannel().position(programHeader.pOffset);
        SplitElfFile.readUntilLimit(this.fis.getChannel(), result, "failed to read segment (type: " + programHeader.pType + ").");
        return result;
    }

    @Override
    public void close() throws IOException {
        this.fis.close();
        this.sectionNameToHeaderMap.clear();
        this.programHeaders = null;
        this.sectionHeaders = null;
    }

    public static class SectionHeader {
        public static final int SHN_UNDEF = 0;
        public static final int SHN_LORESERVE = 65280;
        public static final int SHN_LOPROC = 65280;
        public static final int SHN_HIPROC = 65311;
        public static final int SHN_ABS = 65521;
        public static final int SHN_COMMON = 65522;
        public static final int SHN_HIRESERVE = 65535;
        public static final int SHT_NULL = 0;
        public static final int SHT_PROGBITS = 1;
        public static final int SHT_SYMTAB = 2;
        public static final int SHT_STRTAB = 3;
        public static final int SHT_RELA = 4;
        public static final int SHT_HASH = 5;
        public static final int SHT_DYNAMIC = 6;
        public static final int SHT_NOTE = 7;
        public static final int SHT_NOBITS = 8;
        public static final int SHT_REL = 9;
        public static final int SHT_SHLIB = 10;
        public static final int SHT_DYNSYM = 11;
        public static final int SHT_LOPROC = 0x70000000;
        public static final int SHT_HIPROC = Integer.MAX_VALUE;
        public static final int SHT_LOUSER = Integer.MIN_VALUE;
        public static final int SHT_HIUSER = -1;
        public static final int SHF_WRITE = 1;
        public static final int SHF_ALLOC = 2;
        public static final int SHF_EXECINSTR = 4;
        public static final int SHF_MASKPROC = -268435456;
        public final int shName;
        public final int shType;
        public final long shFlags;
        public final long shAddr;
        public final long shOffset;
        public final long shSize;
        public final int shLink;
        public final int shInfo;
        public final long shAddrAlign;
        public final long shEntSize;
        public String shNameStr;

        private SectionHeader(ByteBuffer buffer, int elfClass) throws IOException {
            switch (elfClass) {
                case 1: {
                    this.shName = buffer.getInt();
                    this.shType = buffer.getInt();
                    this.shFlags = buffer.getInt();
                    this.shAddr = buffer.getInt();
                    this.shOffset = buffer.getInt();
                    this.shSize = buffer.getInt();
                    this.shLink = buffer.getInt();
                    this.shInfo = buffer.getInt();
                    this.shAddrAlign = buffer.getInt();
                    this.shEntSize = buffer.getInt();
                    break;
                }
                case 2: {
                    this.shName = buffer.getInt();
                    this.shType = buffer.getInt();
                    this.shFlags = buffer.getLong();
                    this.shAddr = buffer.getLong();
                    this.shOffset = buffer.getLong();
                    this.shSize = buffer.getLong();
                    this.shLink = buffer.getInt();
                    this.shInfo = buffer.getInt();
                    this.shAddrAlign = buffer.getLong();
                    this.shEntSize = buffer.getLong();
                    break;
                }
                default: {
                    throw new IOException("Unexpected elf class: " + elfClass);
                }
            }
            this.shNameStr = null;
        }
    }

    public static class ProgramHeader {
        public static final int PT_NULL = 0;
        public static final int PT_LOAD = 1;
        public static final int PT_DYNAMIC = 2;
        public static final int PT_INTERP = 3;
        public static final int PT_NOTE = 4;
        public static final int PT_SHLIB = 5;
        public static final int PT_PHDR = 6;
        public static final int PT_LOPROC = 0x70000000;
        public static final int PT_HIPROC = Integer.MAX_VALUE;
        public static final int PF_R = 4;
        public static final int PF_W = 2;
        public static final int PF_X = 1;
        public final int pType;
        public final int pFlags;
        public final long pOffset;
        public final long pVddr;
        public final long pPddr;
        public final long pFileSize;
        public final long pMemSize;
        public final long pAlign;

        private ProgramHeader(ByteBuffer buffer, int elfClass) throws IOException {
            switch (elfClass) {
                case 1: {
                    this.pType = buffer.getInt();
                    this.pOffset = buffer.getInt();
                    this.pVddr = buffer.getInt();
                    this.pPddr = buffer.getInt();
                    this.pFileSize = buffer.getInt();
                    this.pMemSize = buffer.getInt();
                    this.pFlags = buffer.getInt();
                    this.pAlign = buffer.getInt();
                    break;
                }
                case 2: {
                    this.pType = buffer.getInt();
                    this.pFlags = buffer.getInt();
                    this.pOffset = buffer.getLong();
                    this.pVddr = buffer.getLong();
                    this.pPddr = buffer.getLong();
                    this.pFileSize = buffer.getLong();
                    this.pMemSize = buffer.getLong();
                    this.pAlign = buffer.getLong();
                    break;
                }
                default: {
                    throw new IOException("Unexpected elf class: " + elfClass);
                }
            }
        }
    }

    public static class ElfHeader {
        public static final int EI_CLASS = 4;
        public static final int EI_DATA = 5;
        public static final int EI_VERSION = 6;
        public static final int ELFCLASS32 = 1;
        public static final int ELFCLASS64 = 2;
        public static final int ELFDATA2LSB = 1;
        public static final int ELFDATA2MSB = 2;
        public static final int ET_NONE = 0;
        public static final int ET_REL = 1;
        public static final int ET_EXEC = 2;
        public static final int ET_DYN = 3;
        public static final int ET_CORE = 4;
        public static final int ET_LOPROC = 65280;
        public static final int ET_HIPROC = 65535;
        public static final int EV_CURRENT = 1;
        private static final int EI_NINDENT = 16;
        public final byte[] eIndent = new byte[16];
        public final short eType;
        public final short eMachine;
        public final int eVersion;
        public final long eEntry;
        public final long ePhOff;
        public final long eShOff;
        public final int eFlags;
        public final short eEhSize;
        public final short ePhEntSize;
        public final short ePhNum;
        public final short eShEntSize;
        public final short eShNum;
        public final short eShStrNdx;

        private ElfHeader(FileChannel channel) throws IOException {
            channel.position(0L);
            channel.read(ByteBuffer.wrap(this.eIndent));
            if (this.eIndent[0] != 127 || this.eIndent[1] != 69 || this.eIndent[2] != 76 || this.eIndent[3] != 70) {
                throw new IOException(String.format("bad elf magic: %x %x %x %x.", this.eIndent[0], this.eIndent[1], this.eIndent[2], this.eIndent[3]));
            }
            SplitElfFile.assertInRange(this.eIndent[4], 1, 2, "bad elf class: " + this.eIndent[4]);
            SplitElfFile.assertInRange(this.eIndent[5], 1, 2, "bad elf data encoding: " + this.eIndent[5]);
            ByteBuffer restBuffer = ByteBuffer.allocate(this.eIndent[4] == 1 ? 36 : 48);
            restBuffer.order(this.eIndent[5] == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            SplitElfFile.readUntilLimit(channel, restBuffer, "failed to read rest part of ehdr.");
            this.eType = restBuffer.getShort();
            this.eMachine = restBuffer.getShort();
            this.eVersion = restBuffer.getInt();
            SplitElfFile.assertInRange(this.eVersion, 1, 1, "bad elf version: " + this.eVersion);
            switch (this.eIndent[4]) {
                case 1: {
                    this.eEntry = restBuffer.getInt();
                    this.ePhOff = restBuffer.getInt();
                    this.eShOff = restBuffer.getInt();
                    break;
                }
                case 2: {
                    this.eEntry = restBuffer.getLong();
                    this.ePhOff = restBuffer.getLong();
                    this.eShOff = restBuffer.getLong();
                    break;
                }
                default: {
                    throw new IOException("Unexpected elf class: " + this.eIndent[4]);
                }
            }
            this.eFlags = restBuffer.getInt();
            this.eEhSize = restBuffer.getShort();
            this.ePhEntSize = restBuffer.getShort();
            this.ePhNum = restBuffer.getShort();
            this.eShEntSize = restBuffer.getShort();
            this.eShNum = restBuffer.getShort();
            this.eShStrNdx = restBuffer.getShort();
        }
    }
}

