/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.common;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import android.support.annotation.RestrictTo;
import android.text.TextUtils;
import com.iqiyi.android.qigsaw.core.common.SplitLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ProcessUtil {
    private static final String TAG = "Split:ProcessUtil";

    public static void killAllOtherProcess(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        if (am == null) {
            return;
        }
        List appProcessList = am.getRunningAppProcesses();
        if (appProcessList == null) {
            return;
        }
        for (ActivityManager.RunningAppProcessInfo ai : appProcessList) {
            if (ai.uid != Process.myUid() || ai.pid == Process.myPid()) continue;
            Process.killProcess((int)ai.pid);
        }
    }

    public static String getProcessName(Context context) {
        String processName = null;
        try {
            processName = ProcessUtil.getProcessNameClassical(context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (TextUtils.isEmpty((CharSequence)processName)) {
            processName = ProcessUtil.getProcessNameSecure();
            SplitLog.i(TAG, "Get process name: %s in secure mode.", processName);
        }
        return processName;
    }

    private static String getProcessNameSecure() {
        String processName = "";
        try {
            File file = new File("/proc/" + Process.myPid() + "/cmdline");
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            processName = bufferedReader.readLine().trim();
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return processName;
    }

    private static String getProcessNameClassical(Context context) {
        String processName = "";
        int pid = Process.myPid();
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        if (manager == null) {
            return processName;
        }
        List appProcessList = manager.getRunningAppProcesses();
        if (appProcessList == null) {
            return processName;
        }
        for (ActivityManager.RunningAppProcessInfo process : appProcessList) {
            if (process.pid != pid) continue;
            processName = process.processName;
        }
        return processName;
    }
}

