package com.invms.awprotocol.invoker;

import java.io.ByteArrayOutputStream;

import com.alibaba.fastjson.JSONObject;
import com.invms.awprotocol.AWRuntime;
import com.invms.awprotocol.WebResult;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Bitmap.CompressFormat;
import android.os.Bundle;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;

public class GetCameraImage extends BaseWebInvoker {
    protected String imageFormat;
    protected Integer imageQuality;

    @Override
    public boolean isCallback() {
        return true;
    }

    @Override
    public boolean invoke(String args) {
        JSONObject json = initCallback(args);
        imageFormat = json.getString("format");
        imageQuality = json.getInteger("quality");
        Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        webActivity.startActivityForResult(intent, getRequestCode());
        return true;
    }

    protected void callbackImage(Bitmap bitmap) {
        byte[] image = null;
        if (bitmap != null) {
            CompressFormat format;
            if (TextUtils.isEmpty(imageFormat)) {
                format = CompressFormat.JPEG;
            } else {
                switch (imageFormat) {
                    case "png":
                        format = CompressFormat.PNG;
                        break;
                    case "webp":
                        format = CompressFormat.WEBP;
                        break;
                    case "jpg":
                    case "jpeg":
                    default:
                        format = CompressFormat.JPEG;
                        break;
                }
            }
            int quality = imageQuality == null || imageQuality < 0 || imageQuality > 100 ? 100 : imageQuality;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                if (bitmap.compress(format, quality, outputStream)) {
                    image = outputStream.toByteArray();
                }
            } finally {
                try {
                    outputStream.close();
                } catch (Exception e) {
                    Log.e(tag, e.getLocalizedMessage(), e);
                }
            }
        }
        if (image == null) {
            doneCallback(WebResult.createFalse("没有图片"));
        } else {
            doneCallback(WebResult.createTrue(AWRuntime.toBase64(image)));
        }
        imageFormat = null;
        imageQuality = null;
    }

    @Override
    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == Activity.RESULT_OK) {
            Bundle bundle = data.getExtras();
            callbackImage((Bitmap) bundle.get("data"));
        } else {
            callbackImage(null);
        }
        return true;
    }
}