package com.invms.awprotocol.invoker;

import com.alibaba.fastjson.JSONObject;
import com.invms.awprotocol.WebResult;

public abstract class BaseGetConfig extends BaseWebInvoker {
    @Override
    public boolean isCallback() {
        return true;
    }

    protected abstract Object getDefaultValue(JSONObject json);

    protected abstract Object getConfigValue(String key, Object defValue);

    @Override
    public boolean invoke(String args) {
        JSONObject json = initCallback(args);
        String key = json.getString("key");
        Object defValue = getDefaultValue(json);
        Object value = getConfigValue(key, defValue);
        doneCallback(WebResult.createTrue(value));
        return true;
    }
}