/*
 * Decompiled with CFR 0.152.
 */
package com.invms.awprotocol;

import android.util.Log;
import android.webkit.JavascriptInterface;
import com.invms.awprotocol.IWebInvoker;
import com.invms.awprotocol.WebActivity;
import java.util.Locale;

public class WebHandler {
    private static final String tag = WebHandler.class.getName();
    protected final WebActivity webActivity;

    public WebHandler(WebActivity webActivity) {
        this.webActivity = webActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invoke(IWebInvoker webInvoker, String args) {
        try {
            boolean result;
            if (webInvoker.isRunOnSynchronized()) {
                IWebInvoker iWebInvoker = webInvoker;
                synchronized (iWebInvoker) {
                    result = webInvoker.invoke(args);
                }
            } else {
                result = webInvoker.invoke(args);
            }
            Log.d((String)tag, (String)(webInvoker.getName() + " :invoke: " + result));
        }
        catch (Exception e) {
            Log.e((String)tag, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @JavascriptInterface
    public void invoke(String name, String args) {
        Log.d((String)tag, (String)(name + " :start: " + args));
        IWebInvoker webInvoker = this.webActivity.nameWebInvokers.get(name.toLowerCase(Locale.CHINA));
        if (webInvoker != null) {
            if (webInvoker.isRunOnUiThread()) {
                this.webActivity.runOnUiThread(() -> this.invoke(webInvoker, args));
            } else {
                this.invoke(webInvoker, args);
            }
        }
        Log.d((String)tag, (String)(name + " :end: " + args));
    }
}

