package com.invms.awprotocol.invoker;

import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationManager;
import android.os.Bundle;

import com.invms.awprotocol.WebResult;
import com.invms.awprotocol.model.LocationModel;

import java.util.List;

public class GetLastLocation extends BaseWebInvoker {
    protected LocationManager locationManager;

    @Override
    public boolean isCallback() {
        return true;
    }

    @Override
    public boolean invoke(String args) {
        initCallback(args);
        List<String> list = locationManager.getProviders(true);
        Location location;
        if (list.contains(LocationManager.GPS_PROVIDER)) {
            location = locationManager.getLastKnownLocation(LocationManager.GPS_PROVIDER);
        } else if (list.contains(LocationManager.NETWORK_PROVIDER)) {
            location = locationManager.getLastKnownLocation(LocationManager.NETWORK_PROVIDER);
        } else if (list.contains(LocationManager.PASSIVE_PROVIDER)) {
            location = locationManager.getLastKnownLocation(LocationManager.PASSIVE_PROVIDER);
        } else if (list.size() > 0) {
            location = locationManager.getLastKnownLocation(list.get(0));
        } else {
            location = null;
        }
        if (location == null) {
            Criteria criteria = new Criteria();
            criteria.setAccuracy(Criteria.ACCURACY_LOW);
            criteria.setAltitudeRequired(false);
            criteria.setBearingRequired(false);
            criteria.setSpeedRequired(false);
            criteria.setCostAllowed(true);
            criteria.setPowerRequirement(Criteria.POWER_LOW);
            location = locationManager.getLastKnownLocation(locationManager.getBestProvider(criteria, true));
        }
        if (location == null) {
            doneCallback(WebResult.createFalse("获取定位失败"));
        } else {
            doneCallback(WebResult.createTrue(LocationModel.create(location)));
        }
        return true;
    }

    @Override
    public boolean onCreate(Bundle savedInstanceState) {
        locationManager = (LocationManager) webActivity.getSystemService(Context.LOCATION_SERVICE);
        return true;
    }
}