package com.invms.awprotocol;

import java.util.Locale;

import android.util.Log;
import android.webkit.JavascriptInterface;

public class WebHandler {
    private static final String tag = WebHandler.class.getName();

    protected final WebActivity webActivity;

    public WebHandler(WebActivity webActivity) {
        this.webActivity = webActivity;
    }

    protected void invoke(IWebInvoker webInvoker, String args) {
        try {
            boolean result;
            if (webInvoker.isRunOnSynchronized()) {
                synchronized (webInvoker) {
                    result = webInvoker.invoke(args);
                }
            } else {
                result = webInvoker.invoke(args);
            }
            Log.d(tag, webInvoker.getName() + " :invoke: " + result);
        } catch (Exception e) {
            Log.e(tag, e.getLocalizedMessage(), e);
        }
    }

    @JavascriptInterface
    public void invoke(String name, String args) {
        Log.d(tag, name + " :start: " + args);
        IWebInvoker webInvoker = webActivity.nameWebInvokers.get(name.toLowerCase(Locale.CHINA));
        if (webInvoker != null) {
            if (webInvoker.isRunOnUiThread()) {
                webActivity.runOnUiThread(() -> invoke(webInvoker, args));
            } else {
                invoke(webInvoker, args);
            }
        }
        Log.d(tag, name + " :end: " + args);
    }
}