/*
 * Decompiled with CFR 0.152.
 */
package com.invms.awprotocol.invoker;

import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.alibaba.fastjson.JSONObject;
import com.invms.awprotocol.AWRuntime;
import com.invms.awprotocol.WebActivity;
import com.invms.awprotocol.WebResult;
import com.invms.awprotocol.invoker.BaseWebInvoker;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class GetCameraImage
extends BaseWebInvoker {
    private static final String tag = GetCameraImage.class.getName();
    private String callback;
    private String imageFormat;
    private Integer imageQuality;

    @Override
    public boolean invoke(WebActivity webActivity, String args) {
        if (this.callback != null) {
            webActivity.webCallback(this.callback, WebResult.createFalse("\u6709\u65b0\u7684\u8bf7\u6c42"));
        }
        JSONObject json = AWRuntime.fromJson(args, JSONObject.class);
        this.callback = json.getString("callback");
        this.imageFormat = json.getString("format");
        this.imageQuality = json.getInteger("quality");
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        webActivity.startActivityForResult(intent, this.getRequestCode());
        return true;
    }

    @Override
    public boolean callback(WebActivity webActivity, int resultCode, Intent data) {
        if (resultCode == -1) {
            Bundle bundle = data.getExtras();
            this.callback(webActivity, (Bitmap)bundle.get("data"));
        } else {
            this.callback(webActivity, null);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callback(WebActivity webActivity, Bitmap bitmap) {
        if (this.callback != null) {
            byte[] image = null;
            if (bitmap != null) {
                Bitmap.CompressFormat format;
                if (TextUtils.isEmpty((CharSequence)this.imageFormat)) {
                    format = Bitmap.CompressFormat.JPEG;
                } else {
                    switch (this.imageFormat) {
                        case "png": {
                            format = Bitmap.CompressFormat.PNG;
                            break;
                        }
                        case "webp": {
                            format = Bitmap.CompressFormat.WEBP;
                            break;
                        }
                        default: {
                            format = Bitmap.CompressFormat.JPEG;
                        }
                    }
                }
                int quality = this.imageQuality == null || this.imageQuality < 0 || this.imageQuality > 100 ? 100 : this.imageQuality;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                try {
                    if (bitmap.compress(format, quality, (OutputStream)outputStream)) {
                        image = outputStream.toByteArray();
                    }
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (Exception e) {
                        Log.e((String)tag, (String)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            if (image == null) {
                webActivity.webCallback(this.callback, WebResult.createFalse("\u6ca1\u6709\u56fe\u7247"));
            } else {
                webActivity.webCallback(this.callback, WebResult.createTrue(image));
            }
            this.callback = null;
            this.imageFormat = null;
            this.imageQuality = null;
        }
    }
}

