package com.invms.awprotocol;

import java.util.Locale;

import android.util.Log;
import android.webkit.JavascriptInterface;

public class WebHandler {
    private static final String tag = WebHandler.class.getName();
    private final WebActivity webActivity;

    public WebHandler(WebActivity webActivity) {
        this.webActivity = webActivity;
    }

    @JavascriptInterface
    public void invoke(String name, String args) {
        Log.d(tag, name + " :start: " + args);
        IWebInvoker webInvoker = webActivity.nameWebInvokers.get(name.toLowerCase(Locale.CHINA));
        if (webInvoker != null) {
            try {
                Log.d(tag, name + " :invoke: " + webInvoker.invoke(webActivity, args));
                return;
            } catch (Exception e) {
                Log.e(tag, e.getLocalizedMessage(), e);
            }
        }
        Log.d(tag, name + " :end: " + args);
    }
}