package com.invms.awprotocol;

import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;

public class WebChrome extends WebChromeClient {
    private static final String tag = WebChrome.class.getName();
    private final WebActivity webActivity;

    private ValueCallback<Uri[]> showFileCallback;

    public WebChrome(WebActivity webActivity) {
        this.webActivity = webActivity;
    }

    @Override
    public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, FileChooserParams fileChooserParams) {
        Log.d(tag, "onShowFileChooser");
        try {
            if (showFileCallback != null) {
                showFileCallback.onReceiveValue(null);
            }
            showFileCallback = filePathCallback;
            Intent intent = fileChooserParams.createIntent();
            webActivity.startActivityForResult(intent, WebActivity.showFileResultCode);
            return true;
        } catch (Exception e) {
            Log.e(tag, e.getLocalizedMessage(), e);
        }
        return super.onShowFileChooser(webView, filePathCallback, fileChooserParams);
    }

    public void callbackShowFile(Uri[] uris) {
        Log.d(tag, "showFileUris : " + (uris == null ? "none" : TextUtils.join(",", uris)));
        if (showFileCallback != null) {
            showFileCallback.onReceiveValue(uris);
            showFileCallback = null;
        }
    }
}