/*
 * Decompiled with CFR 0.152.
 */
package com.interaso.webpush;

import com.interaso.webpush.CryptoKt;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/interaso/webpush/VapidKeys;", "", "publicKey", "Ljava/security/interfaces/ECPublicKey;", "privateKey", "Ljava/security/interfaces/ECPrivateKey;", "(Ljava/security/interfaces/ECPublicKey;Ljava/security/interfaces/ECPrivateKey;)V", "applicationServerKey", "", "getApplicationServerKey", "()[B", "pkcs8PrivateKey", "", "getPkcs8PrivateKey", "()Ljava/lang/String;", "getPrivateKey", "()Ljava/security/interfaces/ECPrivateKey;", "getPublicKey", "()Ljava/security/interfaces/ECPublicKey;", "x509PublicKey", "getX509PublicKey", "Factory", "webpush"})
public final class VapidKeys {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final ECPublicKey publicKey;
    @NotNull
    private final ECPrivateKey privateKey;
    @NotNull
    private final byte[] applicationServerKey;
    @NotNull
    private final String x509PublicKey;
    @NotNull
    private final String pkcs8PrivateKey;

    public VapidKeys(@NotNull ECPublicKey publicKey, @NotNull ECPrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.applicationServerKey = CryptoKt.getUncompressedBytes(this.publicKey);
        byte[] byArray = this.publicKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        this.x509PublicKey = CryptoKt.encodeBase64(byArray);
        byte[] byArray2 = this.privateKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoded(...)");
        this.pkcs8PrivateKey = CryptoKt.encodeBase64(byArray2);
        if (!CryptoKt.areKeysValidPair(this.privateKey, this.publicKey)) {
            boolean bl = false;
            String string = "Public key does not corresponds to private key";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final ECPublicKey getPublicKey() {
        return this.publicKey;
    }

    @NotNull
    public final ECPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @NotNull
    public final byte[] getApplicationServerKey() {
        return this.applicationServerKey;
    }

    @NotNull
    public final String getX509PublicKey() {
        return this.x509PublicKey;
    }

    @NotNull
    public final String getPkcs8PrivateKey() {
        return this.pkcs8PrivateKey;
    }

    @JvmStatic
    @NotNull
    public static final VapidKeys generate() {
        return Factory.generate();
    }

    @JvmStatic
    @NotNull
    public static final VapidKeys create(@NotNull String x509PublicKey, @NotNull String pkcs8PrivateKey) {
        return Factory.create(x509PublicKey, pkcs8PrivateKey);
    }

    @JvmStatic
    @NotNull
    public static final VapidKeys fromUncompressedBytes(@NotNull String publicKey, @NotNull String privateKey) {
        return Factory.fromUncompressedBytes(publicKey, privateKey);
    }

    @JvmStatic
    @NotNull
    public static final VapidKeys load(@NotNull Path path, boolean generateMissing) {
        return Factory.load(path, generateMissing);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\u001a\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lcom/interaso/webpush/VapidKeys$Factory;", "", "()V", "create", "Lcom/interaso/webpush/VapidKeys;", "x509PublicKey", "", "pkcs8PrivateKey", "fromUncompressedBytes", "publicKey", "privateKey", "generate", "load", "path", "Ljava/nio/file/Path;", "generateMissing", "", "webpush"})
    @SourceDebugExtension(value={"SMAP\nVapidKeys.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VapidKeys.kt\ncom/interaso/webpush/VapidKeys$Factory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
    public static final class Factory {
        private Factory() {
        }

        @JvmStatic
        @NotNull
        public final VapidKeys generate() {
            KeyPair $this$generate_u24lambda_u240 = CryptoKt.generateSecp256r1KeyPair();
            boolean bl = false;
            PublicKey publicKey = $this$generate_u24lambda_u240.getPublic();
            Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
            ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
            PrivateKey privateKey = $this$generate_u24lambda_u240.getPrivate();
            Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPrivateKey");
            return new VapidKeys(eCPublicKey, (ECPrivateKey)privateKey);
        }

        @JvmStatic
        @NotNull
        public final VapidKeys create(@NotNull String x509PublicKey, @NotNull String pkcs8PrivateKey) {
            Intrinsics.checkNotNullParameter((Object)x509PublicKey, (String)"x509PublicKey");
            Intrinsics.checkNotNullParameter((Object)pkcs8PrivateKey, (String)"pkcs8PrivateKey");
            return new VapidKeys(CryptoKt.generatePublicKeyFromX509(CryptoKt.decodeBase64(x509PublicKey)), CryptoKt.generatePrivateKeyFromPkcs8(CryptoKt.decodeBase64(pkcs8PrivateKey)));
        }

        @JvmStatic
        @NotNull
        public final VapidKeys fromUncompressedBytes(@NotNull String publicKey, @NotNull String privateKey) {
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            return new VapidKeys(CryptoKt.generatePublicKeyFromUncompressedBytes(CryptoKt.decodeBase64(publicKey)), CryptoKt.generatePrivateKeyFromUncompressedBytes(CryptoKt.decodeBase64(privateKey)));
        }

        @JvmStatic
        @NotNull
        public final VapidKeys load(@NotNull Path path, boolean generateMissing) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && generateMissing) {
                VapidKeys vapidKeys;
                VapidKeys $this$load_u24lambda_u241 = vapidKeys = this.generate();
                boolean bl = false;
                PathsKt.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
                Path path2 = path;
                Object object = new String[]{$this$load_u24lambda_u241.getX509PublicKey(), $this$load_u24lambda_u241.getPkcs8PrivateKey()};
                object = CollectionsKt.listOf((Object[])object);
                OpenOption[] openOptionArray = new OpenOption[]{};
                Charset charset = Charsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)Files.write(path2, (Iterable<? extends CharSequence>)object, charset, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"write(...)");
                return vapidKeys;
            }
            Path path3 = path;
            List<String> list = Files.readAllLines(path3, Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
            List<String> list2 = list;
            boolean bl = false;
            String x509PublicKey = list2.get(0);
            String pkcs8PrivateKey = list2.get(1);
            return Factory.create(x509PublicKey, pkcs8PrivateKey);
        }

        public static /* synthetic */ VapidKeys load$default(Factory factory, Path path, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return factory.load(path, bl);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

