/*
 * Decompiled with CFR 0.152.
 */
package com.interaso.webpush;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a!\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\r\"\u00020\u000bH\u0000\u00a2\u0006\u0002\u0010\u000e\u001a\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0000\u001a(\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u000bH\u0000\u001a \u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u000bH\u0000\u001a\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u000bH\u0000\u001a\u0010\u0010!\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\"\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u000bH\u0000\u001a\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u0015H\u0000\u001a\b\u0010%\u001a\u00020&H\u0000\u001a\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0000\u001a(\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u0015H\u0000\u001a\u0018\u0010-\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u000bH\u0002\u001a\u0018\u0010/\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"CURVE", "", "secp256r1parameterSpec", "Ljava/security/spec/ECParameterSpec;", "areKeysValidPair", "", "privateKey", "Ljava/security/interfaces/ECPrivateKey;", "publicKey", "Ljava/security/interfaces/ECPublicKey;", "concatBytes", "", "arrays", "", "([[B)[B", "convertDerToJose", "der", "createEs256Jwt", "subject", "audience", "expiration", "", "decodeBase64", "string", "encodeBase64", "bytes", "encryptAesGcmNoPadding", "key", "nonce", "payload", "generateEcdhSharedSecret", "generatePrivateKeyFromPkcs8", "generatePrivateKeyFromUncompressedBytes", "generatePublicKeyFromUncompressedBytes", "generatePublicKeyFromX509", "generateSalt", "size", "generateSecp256r1KeyPair", "Ljava/security/KeyPair;", "getUncompressedBytes", "hkdfSha256", "input", "salt", "info", "length", "hmacSha256", "data", "signSha256withEcdsa", "webpush"})
@SourceDebugExtension(value={"SMAP\nCrypto.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Crypto.kt\ncom/interaso/webpush/CryptoKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,311:1\n1#2:312\n*E\n"})
public final class CryptoKt {
    @NotNull
    private static final String CURVE = "secp256r1";
    @NotNull
    private static final ECParameterSpec secp256r1parameterSpec;

    @NotNull
    public static final KeyPair generateSecp256r1KeyPair() {
        KeyPairGenerator $this$generateSecp256r1KeyPair_u24lambda_u241 = KeyPairGenerator.getInstance("EC");
        boolean bl = false;
        $this$generateSecp256r1KeyPair_u24lambda_u241.initialize(new ECGenParameterSpec(CURVE));
        KeyPair keyPair = $this$generateSecp256r1KeyPair_u24lambda_u241.generateKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"run(...)");
        return keyPair;
    }

    public static final boolean areKeysValidPair(@NotNull ECPrivateKey privateKey, @NotNull ECPublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Signature $this$areKeysValidPair_u24lambda_u242 = Signature.getInstance("SHA256withECDSA");
        boolean bl = false;
        byte[] byArray = new byte[]{1, 2, 3};
        byte[] test = byArray;
        $this$areKeysValidPair_u24lambda_u242.initSign(privateKey);
        $this$areKeysValidPair_u24lambda_u242.update(test);
        byte[] signature = $this$areKeysValidPair_u24lambda_u242.sign();
        $this$areKeysValidPair_u24lambda_u242.initVerify(publicKey);
        $this$areKeysValidPair_u24lambda_u242.update(test);
        return $this$areKeysValidPair_u24lambda_u242.verify(signature);
    }

    @NotNull
    public static final ECPrivateKey generatePrivateKeyFromPkcs8(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        PrivateKey privateKey = KeyFactory.getInstance("EC").generatePrivate(new PKCS8EncodedKeySpec(bytes));
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPrivateKey");
        return (ECPrivateKey)privateKey;
    }

    @NotNull
    public static final ECPublicKey generatePublicKeyFromX509(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        PublicKey publicKey = KeyFactory.getInstance("EC").generatePublic(new X509EncodedKeySpec(bytes));
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        return (ECPublicKey)publicKey;
    }

    @NotNull
    public static final byte[] encryptAesGcmNoPadding(@NotNull byte[] key, @NotNull byte[] nonce, @NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Cipher $this$encryptAesGcmNoPadding_u24lambda_u243 = Cipher.getInstance("AES/GCM/NoPadding");
        boolean bl = false;
        $this$encryptAesGcmNoPadding_u24lambda_u243.init(1, (Key)new SecretKeySpec(key, "AES"), new GCMParameterSpec(128, nonce));
        byte[] byArray = $this$encryptAesGcmNoPadding_u24lambda_u243.doFinal(payload);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"run(...)");
        return byArray;
    }

    @NotNull
    public static final byte[] generateEcdhSharedSecret(@NotNull ECPrivateKey privateKey, @NotNull ECPublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        KeyAgreement $this$generateEcdhSharedSecret_u24lambda_u244 = KeyAgreement.getInstance("ECDH");
        boolean bl = false;
        $this$generateEcdhSharedSecret_u24lambda_u244.init(privateKey);
        $this$generateEcdhSharedSecret_u24lambda_u244.doPhase(publicKey, true);
        byte[] byArray = $this$generateEcdhSharedSecret_u24lambda_u244.generateSecret();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"run(...)");
        return byArray;
    }

    @NotNull
    public static final byte[] hkdfSha256(@NotNull byte[] input, @NotNull byte[] salt, @NotNull byte[] info, int length) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        byte[] byArray = CryptoKt.hmacSha256(CryptoKt.hmacSha256(salt, input), ArraysKt.plus((byte[])info, (byte)1));
        int n = 0;
        return ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)length);
    }

    private static final byte[] hmacSha256(byte[] key, byte[] data) {
        Mac $this$hmacSha256_u24lambda_u245 = Mac.getInstance("HmacSHA256");
        boolean bl = false;
        $this$hmacSha256_u24lambda_u245.init(new SecretKeySpec(key, "HmacSHA256"));
        byte[] byArray = $this$hmacSha256_u24lambda_u245.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"run(...)");
        return byArray;
    }

    @NotNull
    public static final String createEs256Jwt(@NotNull String subject, @NotNull String audience, int expiration, @NotNull ECPrivateKey privateKey) {
        String encodedToken;
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)audience, (String)"audience");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        long expiresAt = System.currentTimeMillis() / (long)1000 + (long)expiration;
        String payload = "{\"sub\":\"" + subject + "\",\"aud\":\"" + audience + "\",\"exp\":" + expiresAt + "}";
        String string = "{\"alg\":\"ES256\",\"typ\":\"JWT\"}";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String encodedHeader = CryptoKt.encodeBase64(byArray);
        String string2 = payload;
        byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        String encodedPayload = CryptoKt.encodeBase64(byArray2);
        String string3 = encodedToken = encodedHeader + "." + encodedPayload;
        byte[] byArray3 = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
        byte[] signature = CryptoKt.signSha256withEcdsa(privateKey, byArray3);
        String encodedSignature = CryptoKt.encodeBase64(CryptoKt.convertDerToJose(signature));
        return encodedToken + "." + encodedSignature;
    }

    private static final byte[] signSha256withEcdsa(ECPrivateKey privateKey, byte[] bytes) {
        Signature $this$signSha256withEcdsa_u24lambda_u246 = Signature.getInstance("SHA256withECDSA");
        boolean bl = false;
        $this$signSha256withEcdsa_u24lambda_u246.initSign(privateKey);
        $this$signSha256withEcdsa_u24lambda_u246.update(bytes);
        byte[] byArray = $this$signSha256withEcdsa_u24lambda_u246.sign();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"run(...)");
        return byArray;
    }

    @NotNull
    public static final byte[] getUncompressedBytes(@NotNull ECPublicKey publicKey) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        byte[] x = publicKey.getW().getAffineX().toByteArray();
        byte[] y = publicKey.getW().getAffineY().toByteArray();
        int xStart = x.length == 33 && x[0] == 0 ? 1 : 0;
        int yStart = y.length == 33 && y[0] == 0 ? 1 : 0;
        byte[] array = byArray = new byte[65];
        boolean bl = false;
        array[0] = 4;
        Intrinsics.checkNotNull((Object)x);
        ArraysKt.copyInto((byte[])x, (byte[])array, (int)(33 - (x.length - xStart)), (int)xStart, (int)x.length);
        Intrinsics.checkNotNull((Object)y);
        ArraysKt.copyInto((byte[])y, (byte[])array, (int)(65 - (y.length - yStart)), (int)yStart, (int)y.length);
        return byArray;
    }

    @NotNull
    public static final ECPublicKey generatePublicKeyFromUncompressedBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        byte[] byArray = bytes;
        int n = 1;
        int n2 = 33;
        BigInteger bigInteger = new BigInteger(1, ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2));
        byArray = bytes;
        n = 33;
        n2 = 65;
        ECPoint ecPoint = new ECPoint(bigInteger, new BigInteger(1, ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2)));
        KeyFactory $this$generatePublicKeyFromUncompressedBytes_u24lambda_u248 = KeyFactory.getInstance("EC");
        boolean bl = false;
        PublicKey publicKey = $this$generatePublicKeyFromUncompressedBytes_u24lambda_u248.generatePublic(new ECPublicKeySpec(ecPoint, secp256r1parameterSpec));
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        return (ECPublicKey)publicKey;
    }

    @NotNull
    public static final ECPrivateKey generatePrivateKeyFromUncompressedBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        KeyFactory $this$generatePrivateKeyFromUncompressedBytes_u24lambda_u249 = KeyFactory.getInstance("EC");
        boolean bl = false;
        PrivateKey privateKey = $this$generatePrivateKeyFromUncompressedBytes_u24lambda_u249.generatePrivate(new ECPrivateKeySpec(new BigInteger(bytes), secp256r1parameterSpec));
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPrivateKey");
        return (ECPrivateKey)privateKey;
    }

    @NotNull
    public static final byte[] generateSalt(int size) {
        byte[] byArray = SecureRandom.getSeed(size);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getSeed(...)");
        return byArray;
    }

    @NotNull
    public static final String encodeBase64(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        String string = Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    @NotNull
    public static final byte[] decodeBase64(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        byte[] byArray = Base64.getUrlDecoder().decode(string);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        return byArray;
    }

    @NotNull
    public static final byte[] convertDerToJose(@NotNull byte[] der) {
        Intrinsics.checkNotNullParameter((Object)der, (String)"der");
        int numberSize = 32;
        int offset = 3;
        byte[] jose = new byte[numberSize * 2];
        if (der[1] == -127) {
            // empty if block
        }
        int n = ++offset;
        byte rLength = der[n];
        int rPadding = numberSize - rLength;
        ArraysKt.copyInto((byte[])der, (byte[])jose, (int)Math.max(rPadding, 0), (int)(++offset + Math.max(-rPadding, 0)), (int)(offset + Math.max(-rPadding, 0) + (rLength - Math.max(-rPadding, 0))));
        offset += rLength + 1;
        byte sLength = der[offset++];
        int sPadding = numberSize - sLength;
        ArraysKt.copyInto((byte[])der, (byte[])jose, (int)(numberSize + Math.max(sPadding, 0)), (int)(offset + Math.max(-sPadding, 0)), (int)(offset + Math.max(-sPadding, 0) + (sLength - Math.max(-sPadding, 0))));
        return jose;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] concatBytes(byte[] ... arrays) {
        Intrinsics.checkNotNullParameter((Object)arrays, (String)"arrays");
        Object[] objectArray = (Object[])arrays;
        int n = 0;
        for (Object object : objectArray) {
            void it;
            byte[] byArray = (byte[])object;
            int n2 = n;
            boolean bl = false;
            int n3 = ((void)it).length;
            n = n2 + n3;
        }
        byte[] result = new byte[n];
        int position = 0;
        int n4 = ((Object[])arrays).length;
        for (n = 0; n < n4; ++n) {
            byte[] array = arrays[n];
            ArraysKt.copyInto$default((byte[])array, (byte[])result, (int)position, (int)0, (int)0, (int)12, null);
            position += array.length;
        }
        return result;
    }

    static {
        AlgorithmParameters $this$secp256r1parameterSpec_u24lambda_u240 = AlgorithmParameters.getInstance("EC");
        boolean bl = false;
        $this$secp256r1parameterSpec_u24lambda_u240.init(new ECGenParameterSpec(CURVE));
        ECParameterSpec eCParameterSpec = $this$secp256r1parameterSpec_u24lambda_u240.getParameterSpec(ECParameterSpec.class);
        Intrinsics.checkNotNullExpressionValue((Object)eCParameterSpec, (String)"run(...)");
        secp256r1parameterSpec = eCParameterSpec;
    }
}

