/*
 * Decompiled with CFR 0.152.
 */
package com.instapp.nat.weex.plugin.Camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.alibaba.weex.plugin.annotation.WeexModule;
import com.instapp.nat.camera.CameraModule;
import com.instapp.nat.camera.Util;
import com.instapp.nat.permission.ModuleResultListener;
import com.instapp.nat.permission.PermissionChecker;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.WXModule;
import java.util.HashMap;
import java.util.Locale;

@WeexModule(name="nat/camera")
public class Camera
extends WXModule {
    JSCallback mImageCallBack;
    JSCallback mVideoCallBack;
    String lang = Locale.getDefault().getLanguage();
    Boolean isChinese = this.lang.startsWith("zh");

    @JSMethod
    public void captureImage(HashMap<String, Object> param, final JSCallback jsCallback) {
        boolean b = PermissionChecker.lacksPermissions((Context)this.mWXSDKInstance.getContext(), (String[])new String[]{"android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"});
        if (b) {
            HashMap<String, String> dialog = new HashMap<String, String>();
            if (this.isChinese.booleanValue()) {
                dialog.put("title", "\u6743\u9650\u7533\u8bf7");
                dialog.put("message", "\u8bf7\u5141\u8bb8\u62cd\u7167");
            } else {
                dialog.put("title", "Permission Request");
                dialog.put("message", "Please allow the app to use the camera");
            }
            PermissionChecker.requestPermissions((Activity)((Activity)this.mWXSDKInstance.getContext()), dialog, (ModuleResultListener)new ModuleResultListener(){

                public void onResult(Object o) {
                    if (((Boolean)o).booleanValue()) {
                        jsCallback.invoke((Object)Util.getError((String)"CAMERA_PERMISSION_DENIED", (int)120020));
                    }
                }
            }, (int)1504, (String[])new String[]{"android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"});
        } else {
            this.realCaptureImage(param, jsCallback);
        }
    }

    public void realCaptureImage(HashMap<String, Object> param, final JSCallback jsCallback) {
        this.mImageCallBack = jsCallback;
        CameraModule.getInstance((Context)this.mWXSDKInstance.getContext()).captureImage((Activity)this.mWXSDKInstance.getContext(), new com.instapp.nat.camera.ModuleResultListener(){

            public void onResult(Object o) {
                jsCallback.invoke(o);
            }
        });
    }

    @JSMethod
    public void captureVideo(HashMap<String, Object> param, final JSCallback jsCallback) {
        boolean b = PermissionChecker.lacksPermissions((Context)this.mWXSDKInstance.getContext(), (String[])new String[]{"android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"});
        if (b) {
            HashMap<String, String> dialog = new HashMap<String, String>();
            if (this.isChinese.booleanValue()) {
                dialog.put("title", "\u6743\u9650\u7533\u8bf7");
                dialog.put("message", "\u8bf7\u5141\u8bb8\u5e94\u7528\u4f7f\u7528\u76f8\u673a");
            } else {
                dialog.put("title", "Permission Request");
                dialog.put("message", "Please allow the app to use the camera");
            }
            PermissionChecker.requestPermissions((Activity)((Activity)this.mWXSDKInstance.getContext()), dialog, (ModuleResultListener)new ModuleResultListener(){

                public void onResult(Object o) {
                    if (((Boolean)o).booleanValue()) {
                        jsCallback.invoke((Object)Util.getError((String)"CAMERA_PERMISSION_DENIED", (int)120020));
                    }
                }
            }, (int)1504, (String[])new String[]{"android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"});
        } else {
            this.realCaptureVideo(param, jsCallback);
        }
    }

    public void realCaptureVideo(HashMap<String, Object> param, final JSCallback jsCallback) {
        this.mVideoCallBack = jsCallback;
        CameraModule.getInstance((Context)this.mWXSDKInstance.getContext()).captureVideo((Activity)this.mWXSDKInstance.getContext(), new com.instapp.nat.camera.ModuleResultListener(){

            public void onResult(Object o) {
                jsCallback.invoke(o);
            }
        });
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Object o = CameraModule.getInstance((Context)this.mWXSDKInstance.getContext()).onCaptureImgActivityResult(requestCode, resultCode, data);
        Object o1 = CameraModule.getInstance((Context)this.mWXSDKInstance.getContext()).onCaptureVideoActivityResult(requestCode, resultCode, data);
        if (this.mImageCallBack != null) {
            this.mImageCallBack.invoke(o);
            this.mImageCallBack = null;
        }
        if (this.mVideoCallBack != null) {
            this.mVideoCallBack.invoke(o1);
            this.mVideoCallBack = null;
        }
    }
}

