/*
 * Decompiled with CFR 0.152.
 */
package com.instapp.nat.geolocation;

import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.CountDownTimer;
import com.instapp.nat.geolocation.ModuleResultListener;
import com.instapp.nat.geolocation.Util;
import java.util.HashMap;
import java.util.List;

public class GeolocationModule {
    private LocationManager mWatchLocationManager;
    int maximumAge = 0;
    int timeout = 10000;
    String model = "highAccuracy";
    MyCountDownTimer countDownTimer;
    LocationListener mLocationListener;
    private Context mContext;
    private static volatile GeolocationModule instance = null;

    private GeolocationModule(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GeolocationModule getInstance(Context context) {
        if (instance != null) return instance;
        Class<GeolocationModule> clazz = GeolocationModule.class;
        synchronized (GeolocationModule.class) {
            if (instance != null) return instance;
            instance = new GeolocationModule(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void get(final ModuleResultListener listener) {
        String locationProvider;
        if (listener == null) {
            return;
        }
        if (this.mContext == null) {
            listener.onResult("Context\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        final LocationManager locationManager = (LocationManager)this.mContext.getSystemService("location");
        List providers = locationManager.getProviders(true);
        if (providers.contains("passive")) {
            locationProvider = "passive";
        } else if (providers.contains("gps")) {
            locationProvider = "gps";
        } else if (providers.contains("network")) {
            locationProvider = "network";
        } else {
            listener.onResult(Util.getError("LOCATION_UNAVAILABLE", 160070));
            return;
        }
        Location location = locationManager.getLastKnownLocation(locationProvider);
        if (location != null) {
            listener.onResult(this.getLocationInfo(location));
            return;
        }
        locationManager.requestLocationUpdates(locationProvider, 0L, 0.0f, new LocationListener(){

            public void onLocationChanged(Location location) {
                listener.onResult(GeolocationModule.this.getLocationInfo(location));
                locationManager.removeUpdates((LocationListener)this);
            }

            public void onStatusChanged(String provider, int status, Bundle extras) {
            }

            public void onProviderEnabled(String provider) {
            }

            public void onProviderDisabled(String provider) {
            }
        });
    }

    public void watch(HashMap<String, Object> options, final ModuleResultListener listener) {
        if (listener == null) {
            return;
        }
        if (this.mContext == null) {
            listener.onResult("Context\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (this.mWatchLocationManager != null) {
            listener.onResult(Util.getError("LOCATION_SERVICE_BUSY", 160030));
            return;
        }
        try {
            this.maximumAge = options.containsKey("maximumAge") ? (Integer)options.get("maximumAge") : this.maximumAge;
            this.timeout = options.containsKey("timeout") ? (Integer)options.get("timeout") : this.timeout;
            this.model = options.containsKey("model") ? (String)options.get("model") : this.model;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            listener.onResult(Util.getError("WATCH_LOCATION_INVALID_ARGUMENT", 160041));
        }
        this.mWatchLocationManager = (LocationManager)this.mContext.getSystemService("location");
        Criteria crite = new Criteria();
        crite.setAccuracy(this.model.equals("highAccuracy") ? 1 : 2);
        crite.setPowerRequirement(1);
        String provider = this.mWatchLocationManager.getBestProvider(crite, true);
        if (provider == null) {
            listener.onResult(Util.getError("LOCATION_UNAVAILABLE", 160070));
            return;
        }
        this.countDownTimer = new MyCountDownTimer(this.timeout, this.timeout, listener);
        this.countDownTimer.start();
        this.mLocationListener = new LocationListener(){

            public void onLocationChanged(Location location) {
                listener.onResult(GeolocationModule.this.getLocationInfo(location));
                if (GeolocationModule.this.countDownTimer != null) {
                    GeolocationModule.this.countDownTimer.cancel();
                    GeolocationModule.this.countDownTimer.start();
                }
            }

            public void onStatusChanged(String s, int i, Bundle bundle) {
            }

            public void onProviderEnabled(String s) {
            }

            public void onProviderDisabled(String s) {
            }
        };
        this.mWatchLocationManager.requestLocationUpdates(provider, (long)this.maximumAge, 0.0f, this.mLocationListener);
    }

    public void clearWatch(ModuleResultListener listener) {
        if (listener == null) {
            return;
        }
        if (this.mWatchLocationManager == null) {
            listener.onResult(Util.getError("LOCATION_SERVICE_BUSY", 160030));
            return;
        }
        if (this.mLocationListener != null) {
            this.mWatchLocationManager.removeUpdates(this.mLocationListener);
            this.mLocationListener = null;
            this.mWatchLocationManager = null;
        }
        if (this.countDownTimer != null) {
            this.countDownTimer.cancel();
            this.countDownTimer = null;
        }
        listener.onResult(null);
    }

    private HashMap<String, Object> getLocationInfo(Location location) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("latitude", location.getLatitude());
        result.put("longitude", location.getLongitude());
        result.put("speed", Float.valueOf(location.getSpeed()));
        result.put("accuracy", Float.valueOf(location.getAccuracy()));
        return result;
    }

    class MyCountDownTimer
    extends CountDownTimer {
        ModuleResultListener mListener;

        public MyCountDownTimer(long millisInFuture, long countDownInterval, ModuleResultListener listener) {
            super(millisInFuture, countDownInterval);
            this.mListener = listener;
        }

        public void onTick(long l) {
        }

        public void onFinish() {
            if (GeolocationModule.this.mLocationListener != null && GeolocationModule.this.mWatchLocationManager != null) {
                GeolocationModule.this.mWatchLocationManager.removeUpdates(GeolocationModule.this.mLocationListener);
            }
            GeolocationModule.this.mWatchLocationManager = null;
            if (GeolocationModule.this.countDownTimer != null) {
                GeolocationModule.this.countDownTimer.cancel();
                GeolocationModule.this.countDownTimer = null;
            }
            this.mListener.onResult(Util.getError("LOCATION_TIMEOUT", 160080));
        }
    }
}

