/*
 * Decompiled with CFR 0.152.
 */
package com.instapp.nat.camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import com.instapp.nat.camera.ModuleResultListener;
import com.instapp.nat.camera.Util;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;

public class CameraModule {
    File finalImageFile = null;
    File videoFile = null;
    boolean mIsTakingPhoto = false;
    boolean mIsTakingVideo = false;
    long mCaptureImgStartTime = System.currentTimeMillis();
    long mCaptureVideoStartTime = System.currentTimeMillis();
    private Context mContext;
    private static volatile CameraModule instance = null;

    private CameraModule(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CameraModule getInstance(Context context) {
        if (instance != null) return instance;
        Class<CameraModule> clazz = CameraModule.class;
        synchronized (CameraModule.class) {
            if (instance != null) return instance;
            instance = new CameraModule(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void captureImage(Activity activity, ModuleResultListener listener) {
        if (this.mIsTakingPhoto) {
            listener.onResult(Util.getError("CAMERA_BUSY", 120030));
            return;
        }
        this.mCaptureImgStartTime = System.currentTimeMillis();
        this.mIsTakingPhoto = true;
        String fileName = "nat_img_" + new Date().getTime() + ".jpg";
        Intent intent = new Intent();
        intent.setAction("android.media.action.IMAGE_CAPTURE");
        intent.addCategory("android.intent.category.DEFAULT");
        try {
            this.finalImageFile = Util.getFile(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            listener.onResult(Util.getError("CAMERA_INTERNAL_ERROR", 120000));
        }
        Uri uri = Uri.fromFile((File)this.finalImageFile);
        intent.putExtra("output", (Parcelable)uri);
        activity.startActivityForResult(intent, 1001);
    }

    public Object onCaptureImgActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode != 1001) {
            return null;
        }
        this.mIsTakingPhoto = false;
        if (resultCode == -1) {
            String absolutePath = this.finalImageFile.getAbsolutePath();
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("path", absolutePath);
            return result;
        }
        long endTime = System.currentTimeMillis();
        if (endTime - this.mCaptureImgStartTime <= 10L) {
            return Util.getError("CAMERA_PERMISSION_DENIED", 120020);
        }
        return null;
    }

    public void captureVideo(Activity activity, ModuleResultListener listener) {
        if (this.mIsTakingVideo) {
            listener.onResult(Util.getError("CAMERA_BUSY", 120030));
            return;
        }
        this.mCaptureVideoStartTime = System.currentTimeMillis();
        this.mIsTakingVideo = true;
        String fileName = "nat_video_" + new Date().getTime() + ".mov";
        Intent intent = new Intent();
        intent.setAction("android.media.action.VIDEO_CAPTURE");
        intent.addCategory("android.intent.category.DEFAULT");
        try {
            this.videoFile = Util.getFile(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Uri uri = Uri.fromFile((File)this.videoFile);
        intent.putExtra("output", (Parcelable)uri);
        activity.startActivityForResult(intent, 1002);
    }

    public Object onCaptureVideoActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode != 1002) {
            return null;
        }
        this.mIsTakingVideo = false;
        if (resultCode == -1) {
            String absolutePath = this.videoFile.getAbsolutePath();
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("path", absolutePath);
            return result;
        }
        long endTime = System.currentTimeMillis();
        if (endTime - this.mCaptureVideoStartTime <= 10L) {
            return Util.getError("CAMERA_PERMISSION_DENIED", 120020);
        }
        return null;
    }
}

