/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.cache;

import android.support.annotation.VisibleForTesting;
import com.instabug.featuresrequest.cache.FeatureRequestCacheManager;
import com.instabug.featuresrequest.models.f;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.util.InstabugSDKLogger;

public class TimelineCacheManager {
    public static final String TIMELINE_DISK_CACHE_FILE_NAME = "/timeline.cache";
    public static final String TIMELINE_DISK_CACHE_KEY = "timeline_disk_cache";
    public static final String TIMELINE_MEMORY_CACHE_KEY = "timeline_memory_cache";

    public static InMemoryCache<Long, f> getCache() throws IllegalArgumentException {
        if (!CacheManager.getInstance().cacheExists(TIMELINE_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(TimelineCacheManager.class, (String)("In-memory comments cache not found, loading it from disk " + CacheManager.getInstance().getCache(TIMELINE_MEMORY_CACHE_KEY)));
            CacheManager.getInstance().migrateCache(TIMELINE_DISK_CACHE_KEY, TIMELINE_MEMORY_CACHE_KEY, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<Long, f>(){

                public Long a(f f2) {
                    return f2.b();
                }

                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((f)object);
                }
            });
            Cache cache = CacheManager.getInstance().getCache(TIMELINE_MEMORY_CACHE_KEY);
            if (cache != null) {
                InstabugSDKLogger.d(TimelineCacheManager.class, (String)("In-memory Comments cache restored from disk, " + cache.size() + " elements restored"));
            }
        }
        InstabugSDKLogger.d(FeatureRequestCacheManager.class, (String)"In-memory Comments cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(TIMELINE_MEMORY_CACHE_KEY);
    }

    @VisibleForTesting
    static void tearDown() {
        CacheManager.getInstance().deleteCache(TIMELINE_DISK_CACHE_KEY);
        CacheManager.getInstance().deleteCache(TIMELINE_MEMORY_CACHE_KEY);
    }

    public static void saveCacheToDisk() {
        Cache cache = CacheManager.getInstance().getCache(TIMELINE_DISK_CACHE_KEY);
        Cache cache2 = CacheManager.getInstance().getCache(TIMELINE_MEMORY_CACHE_KEY);
        if (cache != null && TIMELINE_MEMORY_CACHE_KEY != null) {
            CacheManager.getInstance().migrateCache(cache2, cache, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<String, f>(){

                public String a(f f2) {
                    return String.valueOf(f2.b());
                }

                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((f)object);
                }
            });
        }
    }

    public static f getComments(long featureId) {
        return (f)TimelineCacheManager.getCache().get((Object)featureId);
    }

    public static void addTimeline(f timeline) {
        InMemoryCache<Long, f> inMemoryCache = TimelineCacheManager.getCache();
        if (inMemoryCache != null) {
            inMemoryCache.put((Object)timeline.b(), (Object)timeline);
        }
    }
}

