/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.cache;

import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.instabug.featuresrequest.models.b;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.List;

public class NewFeatureRequestsCacheManager {
    public static final String NEW_FEATURES_DISK_CACHE_FILE_NAME = "/new_feature_requests.cache";
    public static final String NEW_FEATURES_DISK_CACHE_KEY = "new_feature_requests_disk_cache";
    public static final String NEW_FEATURES_MEMORY_CACHE_KEY = "new_feature_requests._memory_cache";

    @Nullable
    public static InMemoryCache<Long, b> getCache() throws IllegalArgumentException {
        if (!CacheManager.getInstance().cacheExists(NEW_FEATURES_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(NewFeatureRequestsCacheManager.class, (String)("In-memory new_feature_requests cache not found, loading it from disk " + CacheManager.getInstance().getCache(NEW_FEATURES_MEMORY_CACHE_KEY)));
            CacheManager.getInstance().migrateCache(NEW_FEATURES_DISK_CACHE_KEY, NEW_FEATURES_MEMORY_CACHE_KEY, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<Long, b>(){

                public Long a(b b2) {
                    return b2.a();
                }

                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((b)object);
                }
            });
            Cache cache = CacheManager.getInstance().getCache(NEW_FEATURES_MEMORY_CACHE_KEY);
            if (cache != null) {
                InstabugSDKLogger.d(NewFeatureRequestsCacheManager.class, (String)("In-memory new_feature_requests cache restored from disk, " + cache.getValues().size() + " elements restored"));
            }
        }
        InstabugSDKLogger.d(NewFeatureRequestsCacheManager.class, (String)"In-memory new_feature_requests cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(NEW_FEATURES_MEMORY_CACHE_KEY);
    }

    @VisibleForTesting
    static void tearDown() {
        CacheManager.getInstance().deleteCache(NEW_FEATURES_MEMORY_CACHE_KEY);
        CacheManager.getInstance().deleteCache(NEW_FEATURES_DISK_CACHE_KEY);
    }

    public static void saveCacheToDisk() {
        final Cache cache = CacheManager.getInstance().getCache(NEW_FEATURES_MEMORY_CACHE_KEY);
        final Cache cache2 = CacheManager.getInstance().getCache(NEW_FEATURES_DISK_CACHE_KEY);
        if (cache != null && cache2 != null) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    CacheManager.getInstance().migrateCache(cache, cache2, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<String, b>(){

                        public String a(b b2) {
                            return String.valueOf(b2.a());
                        }

                        public /* synthetic */ Object extractKey(Object object) {
                            return this.a((b)object);
                        }
                    });
                }
            });
            thread.start();
        }
    }

    public static void addNewFeatureRequest(b featureRequest) {
        InMemoryCache<Long, b> inMemoryCache = NewFeatureRequestsCacheManager.getCache();
        if (inMemoryCache != null) {
            inMemoryCache.put((Object)featureRequest.a(), (Object)featureRequest);
        }
    }

    @Nullable
    public static b getNewFeatureRequest(long featureRequestId) {
        InMemoryCache<Long, b> inMemoryCache = NewFeatureRequestsCacheManager.getCache();
        if (inMemoryCache != null) {
            return (b)inMemoryCache.get((Object)featureRequestId);
        }
        return null;
    }

    @Nullable
    public static b deleteNewFeatureRequest(b featureRequest) {
        InMemoryCache<Long, b> inMemoryCache = NewFeatureRequestsCacheManager.getCache();
        if (inMemoryCache != null) {
            return (b)inMemoryCache.delete((Object)featureRequest.a());
        }
        return null;
    }

    public static List<b> getNewFeatureRequests() {
        InMemoryCache<Long, b> inMemoryCache = NewFeatureRequestsCacheManager.getCache();
        if (inMemoryCache != null) {
            return inMemoryCache.getValues();
        }
        return new ArrayList<b>();
    }
}

