package com.instabug.featuresrequest.ui.featuresmain

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ArrayAdapter
import android.widget.RadioButton
import android.widget.TextView
import androidx.annotation.LayoutRes
import com.instabug.featuresrequest.R

class SortingSpinnerAdapter(
    private val context: Context,
    @LayoutRes private val resource: Int,
    @LayoutRes private val dropDownResource: Int,
    private val items: ArrayList<String>
) :
    ArrayAdapter<String>(context, resource, items) {

    var selectedPosition = 0
    override fun getView(position: Int, convertView: View?, parent: ViewGroup): View {
        var view = convertView
        if (view == null) {
            view = LayoutInflater.from(context).inflate(resource, parent, false)
        }

        view?.findViewById<TextView>(R.id.spinnerItemTextView)?.text = items[position]

        return view ?: super.getView(position, null, parent)
    }

    override fun getDropDownView(position: Int, convertView: View?, parent: ViewGroup): View {
        var view = convertView
        if (view == null) {
            view = LayoutInflater.from(context).inflate(dropDownResource, parent, false)
        }

        view?.findViewById<RadioButton>(R.id.spinnerDropDownItemRadioButton)?.let {
            it.text = items[position]
            it.isChecked = position == selectedPosition
        }
        return view ?: super.getView(position, null, parent)
    }
}