package com.instabug.featuresrequest.ui.featuredetails;

import com.instabug.featuresrequest.models.FeatureRequest;
import com.instabug.featuresrequest.models.TimelineResponse;
import com.instabug.library.core.ui.BaseContract;

import androidx.fragment.app.Fragment;

/**
 * Created by mohamedzakaria on 9/20/17.
 */

public interface FeaturesRequestsDetailsContract {
    interface View extends BaseContract.View<Fragment> {
        void fillData(FeatureRequest featureRequest);

        void handleBackBtnClicked();

        void showNoCommentsLayout();

        void updateVote(FeatureRequest featureRequest);

        void showComments(TimelineResponse timeline);

        void handelCompletedFeaturesActions();

        void updateListHeight();
    }

    interface Presenter extends BaseContract.Presenter {
        void onBackBtnClicked();

        void onVoteButtonClick(FeatureRequest featureRequest);

    }
}
