package com.instabug.featuresrequest.ui.base.featureslist;

import androidx.annotation.StringRes;
import androidx.fragment.app.Fragment;

import com.instabug.featuresrequest.models.FeatureRequest;
import com.instabug.library.core.ui.BaseContract;

/**
 * @author hossam.
 */

public class FeaturesListContract {

    public interface View extends BaseContract.View<Fragment> {
        void showToast(String message);

        void showToast(@StringRes int resourceId);

        void showEmptyView();

        void hideErrorView();

        void showFeatures();

        void showErrorView();

        void hideEmptyView();

        void notifyDataSetChanged();

        void navigateToTheDetailsScreen(FeatureRequest featureRequest);

        void navigateToAddNewFeatureScreen();

        boolean shouldShowMyPosts();

        void handlePoweredByFooter();

        void showFooterView();

        void hideFooterView();

        void setRefreshing(boolean isRefreshing);

        void hideLoadMore();

        void updateItemsOrder();

        void showErrorToastMessage();
    }

    interface Presenter extends BaseContract.Presenter {
        void onFeatureClicked(int position);

        void onUpVoteFeatureClicked(FeatureRequest featureRequest);

        void onUnVoteFeatureClicked(FeatureRequest featureRequest);

        void onLoadMoreTriggered();

        void onPullToRefreshTriggered();

        void handlePbiFooter();

        int getFeaturesCount();

        void onBindFeatureViewItemAtPosition(int position, FeatureHolder holder);

        void onEmptyViewPositiveButtonClicked();

        void onDestroy();

        void onSortActionChanged();

        void onErrorStateClicked();
    }

    interface FeatureRowView {

        void setFeatureTitle(String featureTitle);

        void setFeatureStateColor(FeatureRequest item);

        void setCommentsCount(int commentsCount);

        void setVotesCount(int votesCount);

        void setCreationDate(long date);

        void setVoteButtonStyle(Boolean liked);

        void setVoteButtonListener(FeatureRequest featureRequest);
    }
}