/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.ui.custom;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.Interpolator;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewPropertyAnimatorListener;
import androidx.core.view.ViewPropertyAnimatorListenerAdapter;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.google.android.material.behavior.SwipeDismissBehavior;
import com.instabug.featuresrequest.R;
import com.instabug.featuresrequest.ui.custom.Behavior;
import com.instabug.featuresrequest.ui.custom.InstaToastManager;
import com.instabug.featuresrequest.ui.custom.SnackbarLayout;

public final class InstaToast {
    public static final Interpolator FAST_OUT_SLOW_IN_INTERPOLATOR;
    private static final Handler sHandler;
    private final ViewGroup mParent;
    private final Context mContext;
    private final SnackbarLayout mView;
    private int mDuration;
    private final InstaToastManager.Callback mManagerCallback;

    private InstaToast(ViewGroup viewGroup) {
        InstaToast instaToast = instaToast2;
        instaToast2.mManagerCallback = new InstaToastManager.Callback(){

            @Override
            public void show() {
                sHandler.sendMessage(sHandler.obtainMessage(0, (Object)InstaToast.this));
            }

            @Override
            public void dismiss(int n) {
                InstaToast instaToast = instaToast.InstaToast.this;
                sHandler.sendMessage(sHandler.obtainMessage(1, n, 0, (Object)instaToast));
            }
        };
        instaToast2.mParent = viewGroup;
        InstaToast instaToast2 = viewGroup.getContext();
        instaToast.mContext = instaToast2;
        instaToast.mView = (SnackbarLayout)LayoutInflater.from((Context)instaToast2).inflate(R.layout.ib_fr_insta_toast_layout, viewGroup, false);
    }

    @NonNull
    public static InstaToast make(View view, @NonNull CharSequence charSequence, int n) {
        InstaToast instaToast;
        InstaToast instaToast2 = instaToast;
        instaToast2((ViewGroup)view);
        instaToast2.setText(charSequence);
        instaToast.setDuration(n);
        return instaToast;
    }

    private Drawable fitDrawable(Drawable drawable2, int n) {
        if ((drawable2.getIntrinsicWidth() != n || drawable2.getIntrinsicHeight() != n) && drawable2 instanceof BitmapDrawable) {
            BitmapDrawable bitmapDrawable;
            BitmapDrawable bitmapDrawable2 = bitmapDrawable;
            int n2 = n;
            bitmapDrawable = new BitmapDrawable(this.mContext.getResources(), Bitmap.createScaledBitmap((Bitmap)InstaToast.getBitmap(drawable2), (int)n2, (int)n2, (boolean)true));
            drawable2 = bitmapDrawable2;
        }
        Drawable drawable3 = drawable2;
        int n3 = n;
        drawable3.setBounds(0, 0, n3, n3);
        return drawable3;
    }

    public static float convertDpToPixel(float f, Context context) {
        return f * ((float)context.getResources().getDisplayMetrics().densityDpi / 160.0f);
    }

    @TargetApi(value=21)
    private static Bitmap getBitmap(VectorDrawable vectorDrawable) {
        Canvas canvas;
        Bitmap bitmap = Bitmap.createBitmap((int)vectorDrawable.getIntrinsicWidth(), (int)vectorDrawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        VectorDrawable vectorDrawable2 = vectorDrawable;
        vectorDrawable = canvas;
        int n = new Canvas(bitmap).getWidth();
        int n2 = vectorDrawable.getHeight();
        vectorDrawable2.setBounds(0, 0, n, n2);
        vectorDrawable2.draw((Canvas)vectorDrawable);
        return bitmap;
    }

    private static Bitmap getBitmap(Drawable drawable2) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        if (Build.VERSION.SDK_INT >= 21 && drawable2 instanceof VectorDrawable) {
            return InstaToast.getBitmap((VectorDrawable)drawable2);
        }
        throw new IllegalArgumentException("unsupported drawable type");
    }

    private void dispatchDismiss(int n) {
        InstaToastManager.getInstance().dismiss(this.mManagerCallback, n);
    }

    private void animateViewIn() {
        InstaToast instaToast = this;
        SnackbarLayout snackbarLayout = instaToast.mView;
        ViewCompat.setTranslationY((View)snackbarLayout, (float)(-snackbarLayout.getHeight()));
        ViewCompat.animate((View)instaToast.mView).translationY(0.0f).setInterpolator(FAST_OUT_SLOW_IN_INTERPOLATOR).setDuration(250L).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

            public void onAnimationStart(View view) {
                InstaToast.this.mView.animateChildrenIn(70, 180);
            }

            public void onAnimationEnd(View view) {
                InstaToast.access$600(InstaToast.this);
                InstaToastManager.getInstance().onShown(InstaToast.this.mManagerCallback);
            }
        }).start();
    }

    private void animateViewOut(final int n) {
        ViewCompat.animate((View)this.mView).translationY((float)(-this.mView.getHeight())).setInterpolator(FAST_OUT_SLOW_IN_INTERPOLATOR).setDuration(250L).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

            public void onAnimationStart(View view) {
                InstaToast.this.mView.animateChildrenOut(0, 180);
            }

            public void onAnimationEnd(View view) {
                InstaToast.this.onViewHidden(n);
            }
        }).start();
    }

    private void onViewHidden(int n) {
        InstaToastManager.getInstance().onDismissed(this.mManagerCallback);
        ViewParent viewParent = this.mView.getParent();
        if (viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView((View)this.mView);
        }
    }

    private boolean isBeingDragged() {
        InstaToast instaToast = instaToast.mView.getLayoutParams();
        if (instaToast instanceof CoordinatorLayout.LayoutParams && (instaToast = ((CoordinatorLayout.LayoutParams)instaToast).getBehavior()) instanceof SwipeDismissBehavior) {
            return ((SwipeDismissBehavior)instaToast).getDragState() != 0;
        }
        return false;
    }

    static /* synthetic */ Callback access$600(InstaToast instaToast) {
        instaToast.getClass();
        return null;
    }

    static {
        Handler.Callback callback;
        FAST_OUT_SLOW_IN_INTERPOLATOR = new FastOutSlowInInterpolator();
        Looper looper = Looper.getMainLooper();
        Handler.Callback callback2 = callback;
        callback = new Handler.Callback(){

            public boolean handleMessage(Message message) {
                int n = message.what;
                if (n != 0) {
                    if (n != 1) {
                        return false;
                    }
                    ((InstaToast)message.obj).hideView(message.arg1);
                    return true;
                }
                ((InstaToast)message.obj).showView();
                return true;
            }
        };
        sHandler = new Handler(looper, callback2);
    }

    public InstaToast setIconLeft(@DrawableRes int n, float f) {
        InstaToast instaToast = this;
        TextView textView = instaToast.mView.getMessageView();
        Drawable drawable2 = ContextCompat.getDrawable((Context)instaToast.mContext, (int)n);
        if (drawable2 != null) {
            drawable2 = this.fitDrawable(drawable2, (int)InstaToast.convertDpToPixel(f, this.mContext));
            if (textView != null) {
                TextView textView2 = textView;
                Drawable[] drawableArray = textView2.getCompoundDrawables();
                Drawable drawable3 = drawableArray[1];
                textView = drawableArray[2];
                Drawable drawable4 = drawableArray[3];
                textView2.setCompoundDrawables(drawable2, drawable3, (Drawable)textView, drawable4);
            }
            return this;
        }
        throw new IllegalArgumentException("resource_id is not a valid drawable!");
    }

    public InstaToast setIconRight(@DrawableRes int n, float f) {
        InstaToast instaToast = this;
        TextView textView = instaToast.mView.getMessageView();
        Drawable drawable2 = ContextCompat.getDrawable((Context)instaToast.mContext, (int)n);
        if (drawable2 != null) {
            drawable2 = this.fitDrawable(drawable2, (int)InstaToast.convertDpToPixel(f, this.mContext));
            if (textView != null) {
                TextView textView2 = textView;
                Drawable[] drawableArray = textView2.getCompoundDrawables();
                Drawable drawable3 = drawableArray[0];
                textView = drawableArray[1];
                Drawable drawable4 = drawableArray[3];
                textView2.setCompoundDrawables(drawable3, (Drawable)textView, drawable2, drawable4);
            }
            return this;
        }
        throw new IllegalArgumentException("resource_id is not a valid drawable!");
    }

    public InstaToast setMaxWidth(int n) {
        this.mView.mMaxWidth = n;
        return this;
    }

    @NonNull
    public InstaToast setActionTextColor(@ColorInt int n) {
        Button button = this.mView.getActionView();
        if (button != null) {
            button.setTextColor(n);
        }
        return this;
    }

    @NonNull
    public InstaToast setText(@NonNull CharSequence charSequence) {
        TextView textView = this.mView.getMessageView();
        if (textView != null) {
            textView.setText(charSequence);
        }
        return this;
    }

    @NonNull
    public InstaToast setDuration(int n) {
        this.mDuration = n;
        return this;
    }

    @NonNull
    public View getView() {
        return this.mView;
    }

    public void show() {
        InstaToast instaToast = this;
        int n = instaToast.mDuration;
        InstaToastManager.getInstance().show(n, instaToast.mManagerCallback);
        this.getView().setOnTouchListener(new View.OnTouchListener(){

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getAction() == 1) {
                    InstaToast.this.dismiss();
                }
                return false;
            }
        });
    }

    public void dismiss() {
        this.dispatchDismiss(3);
    }

    public boolean isShownOrQueued() {
        return InstaToastManager.getInstance().isCurrentOrNext(this.mManagerCallback);
    }

    final void showView() {
        if (this.mView.getParent() == null) {
            Object object = this.mView.getLayoutParams();
            if (object instanceof CoordinatorLayout.LayoutParams) {
                Behavior behavior;
                ViewGroup.LayoutParams layoutParams = object;
                object = behavior;
                new Behavior(this.mManagerCallback).setStartAlphaSwipeDistance(0.1f);
                object.setEndAlphaSwipeDistance(0.6f);
                object.setSwipeDirection(0);
                object.setListener(new SwipeDismissBehavior.OnDismissListener(){

                    public void onDismiss(View view) {
                        InstaToast.this.dispatchDismiss(0);
                    }

                    public void onDragStateChanged(int n) {
                        if (n != 0) {
                            if (n == 1 || n == 2) {
                                InstaToastManager.getInstance().cancelTimeout(InstaToast.this.mManagerCallback);
                            }
                        } else {
                            InstaToastManager.getInstance().restoreTimeout(InstaToast.this.mManagerCallback);
                        }
                    }
                });
                ((CoordinatorLayout.LayoutParams)layoutParams).setBehavior((CoordinatorLayout.Behavior)object);
            }
            this.mParent.addView((View)this.mView);
        }
        InstaToast instaToast = this;
        instaToast.mView.setOnAttachStateChangeListener(new SnackbarLayout.OnAttachStateChangeListener(){

            @Override
            public void onViewAttachedToWindow(View view) {
            }

            @Override
            public void onViewDetachedFromWindow(View view) {
                if (InstaToast.this.isShownOrQueued()) {
                    sHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            InstaToast.this.onViewHidden(3);
                        }
                    });
                }
            }
        });
        if (ViewCompat.isLaidOut((View)instaToast.mView)) {
            this.animateViewIn();
        } else {
            this.mView.setOnLayoutChangeListener(new SnackbarLayout.OnLayoutChangeListener(){

                @Override
                @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
                public void onLayoutChange(View view, int n, int n2, int n3, int n4) {
                    7 v0 = this;
                    v0.InstaToast.this.animateViewIn();
                    v0.InstaToast.this.mView.setOnLayoutChangeListener(null);
                }
            });
        }
    }

    final void hideView(int n) {
        if (this.mView.getVisibility() == 0 && !this.isBeingDragged()) {
            this.animateViewOut(n);
        } else {
            this.onViewHidden(n);
        }
    }

    public static abstract class Callback {
    }
}

