package com.instabug.featuresrequest.utils;

import android.content.Context;
import android.graphics.Color;
import android.widget.TextView;

import com.instabug.featuresrequest.R;
import com.instabug.featuresrequest.models.FeatureRequest;

import androidx.annotation.ColorRes;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;

import static com.instabug.featuresrequest.utils.DrawableUtils.setColor;

/**
 * Created by mzelzoghbi on 2/18/18.
 */

public class StatusBinder {
    public static void bind(FeatureRequest.Status featureStatus, String colorCode, @Nullable TextView statusTv,
                            Context context) {

        if(statusTv != null) {
            switch (featureStatus) {
                case Completed:
                    statusTv.setText(R.string.ib_feature_rq_status_completed);
                    setFeatureStateColor(colorCode, statusTv, context, R.color.ib_fr_color_completed);
                    break;
                case InProgress:
                    statusTv.setText(R.string.ib_feature_rq_status_inprogress);
                    setFeatureStateColor(colorCode, statusTv, context, R.color.ib_fr_color_in_progress);
                    break;
                case Planned:
                    statusTv.setText(R.string.ib_feature_rq_status_planned);
                    setFeatureStateColor(colorCode, statusTv, context, R.color.ib_fr_color_planned);
                    break;
                case Open:
                    statusTv.setText(R.string.ib_feature_rq_status_open);
                    setFeatureStateColor(colorCode, statusTv, context, R.color.ib_fr_color_planned);
                    break;
                case MaybeLater:
                    statusTv.setText(R.string.ib_feature_rq_status_maybe_later);
                    setFeatureStateColor(colorCode, statusTv, context, R.color.ib_fr_color_maybe_later);
                    break;
            }
        }
    }

    private static void setFeatureStateColor(String colorCore, TextView statusTv,
                                             Context context, @ColorRes int colorId) {
        if (colorCore != null) {
            setColor(statusTv, Color.parseColor(colorCore));
        } else {
            setColor(statusTv, ContextCompat.getColor(context, colorId));
        }
    }
}
