package com.instabug.featuresrequest.ui.base;

import com.instabug.featuresrequest.models.FeatureRequest;

import java.util.List;

/**
 * @author hossam.
 */

public class FeaturesListBo {
    private BaseFeaturesListDao baseFeaturesListDao;
    private boolean hasNextPage = true;

    public FeaturesListBo(BaseFeaturesListDao baseFeaturesListDao) {
        this.baseFeaturesListDao = baseFeaturesListDao;
    }

    public List<FeatureRequest> getFeatures() {
        return baseFeaturesListDao.getFeatures();
    }

    public int getCompletedFeaturesCount() {
        return baseFeaturesListDao.getCompletedFeaturesCount();
    }

    public int getFeaturesCount() {
        return baseFeaturesListDao.getFeaturesCount();
    }

    public FeatureRequest getFeatureByIndex(int index) {
        return baseFeaturesListDao.getFeatureByIndex(index);
    }

    public void addFeatures(List<FeatureRequest> featureRequests) {
        baseFeaturesListDao.addFeatures(featureRequests);
    }

    public void addFeature(FeatureRequest feature) {
        baseFeaturesListDao.addFeature(feature);
    }

    public int getPage() {
        return baseFeaturesListDao.page;
    }

    public void incrementPageNumber() {
        baseFeaturesListDao.incrementPageNumber();
    }

    public void destroy() {
        baseFeaturesListDao.destroy();
        baseFeaturesListDao.page = 1;
    }

    public boolean hasNextPage() {
        return hasNextPage;
    }

    public void setHasNextPage(boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
    }
}
