package com.instabug.featuresrequest.settings;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;

import androidx.annotation.VisibleForTesting;

import com.instabug.library.Instabug;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;

/**
 * @author hossam.
 */

public class PersistableSettings {

    private static final String KEY_LAST_SORT_BY_ACTION = "last_sort_by_action";
    private static final String KEY_LAST_ACTIVITY = "last_activity";
    private static final String FEATURE_REQUESTS_SHARED_PREF_NAME = "instabug_feature_requests";


    private SharedPreferences sharedPreferences;
    private SharedPreferences.Editor editor;
    private static PersistableSettings persistableSettings;

    @SuppressLint("CommitPrefEdits")
    private PersistableSettings(Context context) {
        sharedPreferences = CoreServiceLocator.getInstabugSharedPreferences(context,
                FEATURE_REQUESTS_SHARED_PREF_NAME);
        if (sharedPreferences != null) {
            editor = sharedPreferences.edit();
        }
    }

    public static void init(Context context) {
        persistableSettings = new PersistableSettings(context);
    }

    @VisibleForTesting
    @SuppressLint("ERADICATE_FIELD_NOT_NULLABLE")
    static void tearDown() {
        persistableSettings = null;
    }

    public static PersistableSettings getInstance() {
        if (persistableSettings == null && Instabug.getApplicationContext() != null)
            init(Instabug.getApplicationContext());
        return persistableSettings;
    }

    public void setLastSortByAction(int action) {
        if (editor == null) return;
        editor.putInt(KEY_LAST_SORT_BY_ACTION, action);
        editor.apply();
    }

    public int getLastSortByAction() {
        if (sharedPreferences == null) return 0;
        return sharedPreferences.getInt(KEY_LAST_SORT_BY_ACTION, 0);
    }

    public long getLastActivityTime() {
        if (sharedPreferences == null) return 0;
        return sharedPreferences.getLong(KEY_LAST_ACTIVITY, 0);
    }

    public void setLastActivityTime(long time) {
        if (editor == null) return;
        editor.putLong(KEY_LAST_ACTIVITY, time);
        editor.apply();
    }

    @VisibleForTesting
    public void resetLastActivityTime() {
        if (editor == null) return;
        editor.putLong(KEY_LAST_ACTIVITY, 0);
        editor.apply();
    }
}