package com.instabug.featuresrequest;

import android.content.Context;

import androidx.annotation.Nullable;

import com.instabug.featuresrequest.cache.FeatureRequestsDBHelper;
import com.instabug.featuresrequest.models.FeatureRequest;
import com.instabug.featuresrequest.network.service.FeaturesRequestVoteJob;
import com.instabug.library.Feature;
import com.instabug.library.IBGFeature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventSubscriber;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.core.eventbus.eventpublisher.IBGCompositeDisposable;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;

import org.json.JSONException;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by mohamedzakaria on 8/28/17.
 */

public class FeaturesRequestPlugin extends Plugin {


    private final IBGCompositeDisposable ibgDisposables = new IBGCompositeDisposable();
    @Override
    public void init(final Context context) {
        super.init(context);
    }


    @Override
    public boolean isFeatureEnabled() {
        return InstabugCore.isFeatureEnabled(IBGFeature.FEATURE_REQUESTS);
    }

    @Override
    public void wake() {
        // TODO map APIs
    }

    @Override
    public void sleep() {
        // TODO map APIs
    }

    @Override
    public void stop() {
        ibgDisposables.dispose();
    }

    @Override
    public void start(final Context context) {
        PoolProvider.postIOTaskWithCheck(() -> {
            FeaturesRequestPluginWrapper.init(context);
            subscribeOnSDKEvents();
        });
    }

    @Override
    public long getLastActivityTime() {
        return FeaturesRequestPluginWrapper.getLastActivityTime();
    }

    private void subscribeOnSDKEvents() {
        ibgDisposables.add(IBGCoreEventSubscriber.subscribe((sdkCoreEvent -> {
            if (sdkCoreEvent instanceof IBGSdkCoreEvent.NetworkActivated)
                submitPendingVotes();

        })));

    }

    private void submitPendingVotes() {
        if (contextWeakReference != null) {
            final Context context = contextWeakReference.get();
            if (context != null) {
                PoolProvider.postIOTask(() -> {
                    try {
                        List<FeatureRequest> featuresList = FeatureRequestsDBHelper.retrieve();
                        if (featuresList != null && !featuresList.isEmpty()) {
                            FeaturesRequestVoteJob.getInstance().start();
                        }
                    } catch (JSONException e) {
                        InstabugSDKLogger.e(Constants.LOG_TAG, "Error occurred during Feature Requests retrieval from DB: " + e.getMessage());
                    }
                });
            } else {
                InstabugSDKLogger.e(Constants.LOG_TAG, "Context is null.");
            }
        } else {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Context WeakReference is null.");
        }
    }

}
