/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.ui.base.featureslist;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PorterDuff;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewStub;
import android.widget.AbsListView;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.fragment.app.Fragment;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.instabug.featuresrequest.R;
import com.instabug.featuresrequest.listeners.OnFeatureClickListener;
import com.instabug.featuresrequest.listeners.OnSortActionChangedListener;
import com.instabug.featuresrequest.models.FeatureRequest;
import com.instabug.featuresrequest.ui.base.featureslist.FeatureAdapter;
import com.instabug.featuresrequest.ui.base.featureslist.FeaturesListContract$View;
import com.instabug.featuresrequest.ui.base.featureslist.FeaturesListPresenter;
import com.instabug.featuresrequest.ui.base.featureslist.OnVoteChangeListener;
import com.instabug.featuresrequest.ui.featuredetails.FeatureRequestsDetailsFragment;
import com.instabug.featuresrequest.ui.newfeature.AddNewFeatureFragment;
import com.instabug.featuresrequest.utils.DrawableUtils;
import com.instabug.featuresrequest.utils.ViewUtilsKt;
import com.instabug.library.Feature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
public abstract class FeaturesListFragment
extends InstabugBaseFragment<FeaturesListPresenter>
implements FeaturesListContract$View,
OnFeatureClickListener,
View.OnClickListener,
OnSortActionChangedListener,
OnVoteChangeListener,
SwipeRefreshLayout.OnRefreshListener {
    @Nullable
    ListView listView;
    FeatureAdapter featureAdapter;
    @Nullable
    private ViewStub emptyStateViewStub;
    @Nullable
    private ViewStub errorStateViewStub;
    protected boolean shouldShowMyPosts = false;
    @Nullable
    private View footerView;
    @Nullable
    private ProgressBar loadMoreProgressBar;
    @Nullable
    private LinearLayout poweredByFooter;
    private boolean footerInflated = false;
    @Nullable
    private SwipeRefreshLayout swipeRefreshLayout;
    private boolean isLoading = false;

    private void registerLoadMoreListener() {
        Object object = this.listView;
        if (object != null) {
            AbsListView.OnScrollListener onScrollListener;
            ListView listView = object;
            object = onScrollListener;
            onScrollListener = new AbsListView.OnScrollListener(){

                public void onScrollStateChanged(AbsListView absListView, int n) {
                }

                public void onScroll(AbsListView absListView, int n, int n2, int n3) {
                    int n4 = n + n2;
                    if (n3 > 0 && n4 == n3 && !FeaturesListFragment.this.isLoading) {
                        1 v0 = this;
                        FeaturesListFragment.access$002(v0.FeaturesListFragment.this, true);
                        if (v0.FeaturesListFragment.this.presenter != null) {
                            ((FeaturesListPresenter)FeaturesListFragment.this.presenter).onLoadMoreTriggered();
                        }
                    }
                }
            };
            listView.setOnScrollListener((AbsListView.OnScrollListener)object);
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private void unRegisterLoadMoreListener() {
        FeaturesListFragment featuresListFragment = featuresListFragment.listView;
        if (featuresListFragment != null) {
            featuresListFragment.setOnScrollListener(null);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private void initLoadingMoreView() {
        block12: {
            var1_1 = this.listView;
            var2_2 = (FeaturesListPresenter)this.presenter;
            if (this.getContext() == null) return;
            if (var1_1 == null) return;
            if (var2_2 == null) return;
            var3_3 = this.footerView;
            if (var3_3 == null) {
                return;
            }
            try {
                if (this.footerInflated) {
                    v0 = var1_1;
                    v1 = v0;
                    v0.removeFooterView(var3_3);
                }
                ** GOTO lbl-1000
            }
            catch (Throwable v2) {
                break block12;
            }
            catch (Exception var3_4) {
                ** GOTO lbl-1000
            }
            {
                v1.addFooterView(this.footerView);
                this.listView = var1_1;
                this.presenter = var2_2;
                return;
            }
lbl-1000:
            // 1 sources

            {
                var3_3 = View.inflate((Context)this.getContext(), (int)R.layout.ib_fr_pull_to_refresh_footer_view, null);
            }
            {
                this.footerView = var3_3;
                if (var3_3 != null) ** GOTO lbl-1000
                this.listView = var1_1;
                this.presenter = var2_2;
                return;
            }
lbl-1000:
            // 1 sources

            {
                this.loadMoreProgressBar = (ProgressBar)var3_3.findViewById(R.id.ib_loadmore_progressbar);
                this.poweredByFooter = (LinearLayout)this.footerView.findViewById(R.id.instabug_pbi_container);
                var3_3 = this.loadMoreProgressBar;
                if (var3_3 == null) ** GOTO lbl36
            }
            {
                var3_3.setVisibility(4);
                this.loadMoreProgressBar.getIndeterminateDrawable().setColorFilter(SettingsManager.getInstance().getPrimaryColor(), PorterDuff.Mode.SRC_IN);
lbl36:
                // 2 sources

                var1_1.addFooterView(this.footerView);
                var2_2.handlePbiFooter();
                this.footerInflated = true;
            }
lbl39:
            // 2 sources

            while (true) {
                this.listView = var1_1;
                this.presenter = var2_2;
                return;
            }
lbl-1000:
            // 1 sources

            {
                InstabugSDKLogger.e((String)"IBG-FR", (String)"exception occurring while setting up the loadMore views", (Throwable)var3_4);
                ** continue;
            }
        }
        this.listView = var1_1;
        this.presenter = var2_2;
        throw v2;
    }

    static /* synthetic */ boolean access$002(FeaturesListFragment featuresListFragment, boolean bl) {
        featuresListFragment.isLoading = bl;
        return bl;
    }

    public void onCreate(@Nullable Bundle bundle) {
        FeaturesListFragment featuresListFragment = this;
        super.onCreate(bundle);
        featuresListFragment.setRetainInstance(true);
    }

    public void showToast(String string2) {
        if (string2 != null && this.getViewContext().getContext() != null) {
            Toast.makeText((Context)this.getViewContext().getContext(), (CharSequence)string2, (int)0).show();
        }
    }

    @Override
    public void showToast(@StringRes int n) {
        if (this.getViewContext().getContext() != null) {
            Toast.makeText((Context)this.getViewContext().getContext(), (CharSequence)this.getLocalizedString(n), (int)0).show();
        }
    }

    @NonNull
    public abstract FeaturesListPresenter getPresenter();

    @Override
    public void showEmptyView() {
        ViewStub viewStub = this.emptyStateViewStub;
        if (viewStub != null) {
            if (viewStub.getParent() != null) {
                View view = this.emptyStateViewStub.inflate();
                viewStub = (Button)view.findViewById(R.id.ib_empty_state_action);
                ImageView imageView = (ImageView)view.findViewById(R.id.ib_empty_state_icon);
                if (imageView != null) {
                    imageView.setImageResource(R.drawable.ibg_fr_ic_features_empty_state);
                }
                ViewStub viewStub2 = viewStub;
                DrawableUtils.setColor((View)viewStub2, SettingsManager.getInstance().getPrimaryColor());
                if (viewStub2 != null) {
                    viewStub.setOnClickListener((View.OnClickListener)this);
                }
            } else {
                this.emptyStateViewStub.setVisibility(0);
            }
        }
    }

    @Override
    public void hideErrorView() {
        FeaturesListFragment featuresListFragment = featuresListFragment.errorStateViewStub;
        if (featuresListFragment != null) {
            featuresListFragment.setVisibility(8);
        }
    }

    @Override
    public void showFeatures() {
        if (this.listView != null) {
            FeaturesListFragment featuresListFragment = this;
            featuresListFragment.initLoadingMoreView();
            featuresListFragment.notifyDataSetChanged();
        }
        FeaturesListFragment featuresListFragment = this;
        ProgressBar progressBar = featuresListFragment.loadMoreProgressBar;
        BaseContract.Presenter presenter = featuresListFragment.presenter;
        if (presenter != null && progressBar != null) {
            if (((FeaturesListPresenter)presenter).hasNext()) {
                progressBar.setVisibility(0);
            } else {
                this.unRegisterLoadMoreListener();
                progressBar.setVisibility(8);
            }
        }
        FeaturesListFragment featuresListFragment2 = this;
        featuresListFragment2.loadMoreProgressBar = progressBar;
        featuresListFragment2.isLoading = false;
    }

    @Override
    public void showErrorView() {
        ViewStub viewStub = this.errorStateViewStub;
        if (viewStub != null) {
            if (viewStub.getParent() != null) {
                this.errorStateViewStub.inflate().setOnClickListener((View.OnClickListener)this);
            } else {
                this.errorStateViewStub.setVisibility(0);
            }
        }
    }

    @Override
    public void hideEmptyView() {
        FeaturesListFragment featuresListFragment = featuresListFragment.emptyStateViewStub;
        if (featuresListFragment != null) {
            featuresListFragment.setVisibility(8);
        }
    }

    @Override
    public void notifyDataSetChanged() {
        Object object = object.featureAdapter;
        if (object != null) {
            object.notifyDataSetChanged();
        }
    }

    @Override
    public void navigateToTheDetailsScreen(FeatureRequest featureRequest) {
        if (this.getActivity() == null) {
            return;
        }
        int n = R.id.instabug_fragment_container;
        this.getActivity().getSupportFragmentManager().beginTransaction().add(n, (Fragment)FeatureRequestsDetailsFragment.newInstance(featureRequest, this)).addToBackStack("feature_requests_details").commit();
    }

    protected int getLayout() {
        return R.layout.ib_fr_features_list_fragment;
    }

    @CallSuper
    protected void initViews(View view, @Nullable Bundle object) {
        FeatureAdapter featureAdapter;
        this.emptyStateViewStub = (ViewStub)this.findViewById(R.id.ib_empty_state_stub);
        this.errorStateViewStub = (ViewStub)this.findViewById(R.id.error_state_stub);
        view = (ListView)this.findViewById(R.id.features_request_list);
        this.listView = view;
        int n = Build.VERSION.SDK_INT;
        if (n > 34 && view != null) {
            ViewUtilsKt.addSystemWindowInsetToPadding(view, true, false, true, true);
        }
        this.registerLoadMoreListener();
        view = (SwipeRefreshLayout)this.findViewById(R.id.swipeRefreshLayout);
        this.swipeRefreshLayout = view;
        if (view == null) {
            return;
        }
        int n2 = SettingsManager.getInstance().getPrimaryColor();
        view.setColorSchemeColors(new int[]{n2});
        this.swipeRefreshLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        if (this.getArguments() != null) {
            this.shouldShowMyPosts = this.getArguments().getBoolean("my_posts", false);
        }
        FeaturesListPresenter featuresListPresenter = (FeaturesListPresenter)this.presenter;
        if (object != null && featuresListPresenter != null) {
            this.footerInflated = false;
            if (object.getBoolean("empty_state") && featuresListPresenter.getFeaturesCount() == 0) {
                this.showEmptyView();
            }
            if (object.getBoolean("error_state") && featuresListPresenter.getFeaturesCount() == 0) {
                this.showErrorView();
            }
            if (featuresListPresenter.getFeaturesCount() > 0) {
                this.initLoadingMoreView();
            }
        } else {
            featuresListPresenter = this.getPresenter();
        }
        this.presenter = featuresListPresenter;
        object = featureAdapter;
        featureAdapter = new FeatureAdapter(featuresListPresenter, this);
        this.featureAdapter = object;
        if (n < 18) {
            this.initLoadingMoreView();
        }
        if ((featuresListPresenter = this.listView) != null) {
            featuresListPresenter.setAdapter((ListAdapter)this.featureAdapter);
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        FeaturesListFragment featuresListFragment = object2;
        super.onSaveInstanceState(bundle);
        Object object = featuresListFragment.emptyStateViewStub;
        if (object != null) {
            ViewStub viewStub = object;
            object = "empty_state";
            boolean bl = viewStub.getParent() == null;
            bundle.putBoolean((String)object, bl);
        }
        if ((object2 = ((FeaturesListFragment)object2).errorStateViewStub) != null) {
            FeaturesListFragment featuresListFragment2 = object2;
            Object object2 = "error_state";
            boolean bl = featuresListFragment2.getParent() == null;
            bundle.putBoolean((String)object2, bl);
        }
    }

    @Override
    public void onVote(FeatureRequest featureRequest) {
        FeaturesListFragment featuresListFragment = featuresListFragment.presenter;
        if (featuresListFragment != null) {
            ((FeaturesListPresenter)((Object)featuresListFragment)).onUpVoteFeatureClicked(featureRequest);
        }
    }

    @Override
    public void onUnVote(FeatureRequest featureRequest) {
        FeaturesListFragment featuresListFragment = featuresListFragment.presenter;
        if (featuresListFragment != null) {
            ((FeaturesListPresenter)((Object)featuresListFragment)).onUnVoteFeatureClicked(featureRequest);
        }
    }

    @Override
    public void onFeatureClicked(int n) {
        FeaturesListFragment featuresListFragment = featuresListFragment.presenter;
        if (featuresListFragment != null) {
            ((FeaturesListPresenter)((Object)featuresListFragment)).onFeatureClicked(n);
        }
    }

    public void onClick(View view) {
        int n = view.getId();
        BaseContract.Presenter presenter = this.presenter;
        if (presenter == null) {
            return;
        }
        if (n == R.id.ib_empty_state_action) {
            ((FeaturesListPresenter)presenter).onEmptyViewPositiveButtonClicked();
        } else {
            presenter = this.errorStateViewStub;
            if (presenter != null && n == presenter.getInflatedId()) {
                ((FeaturesListPresenter)this.presenter).onErrorStateClicked();
            }
        }
    }

    @Override
    public void navigateToAddNewFeatureScreen() {
        if (this.getActivity() == null) {
            return;
        }
        this.getActivity().getSupportFragmentManager().beginTransaction().add(R.id.instabug_fragment_container, (Fragment)new AddNewFeatureFragment()).addToBackStack("search_features").commit();
    }

    @Override
    public boolean shouldShowMyPosts() {
        return this.shouldShowMyPosts;
    }

    @Override
    public void onSortActionChanged(Boolean bl) {
        bl = featuresListFragment2.listView;
        if (bl != null) {
            bl.smoothScrollToPosition(0);
        }
        FeaturesListFragment featuresListFragment = featuresListFragment2;
        featuresListFragment.registerLoadMoreListener();
        FeaturesListFragment featuresListFragment2 = featuresListFragment.presenter;
        if (featuresListFragment2 != null) {
            ((FeaturesListPresenter)((Object)featuresListFragment2)).onSortActionChanged();
        }
    }

    @Override
    public void handlePoweredByFooter() {
        if (this.getActivity() != null && this.footerView != null && this.poweredByFooter != null) {
            if (InstabugCore.getFeatureState((String)"WHITE_LABELING") == Feature.State.ENABLED && !SettingsManager.getInstance().isCustomBrandingEnabled()) {
                this.poweredByFooter.setVisibility(4);
                return;
            }
            FeaturesListFragment featuresListFragment = this;
            InstabugCore.handlePbiFooter((View)featuresListFragment.footerView);
            InstabugCore.handlePbiFooterThemeColor((View)featuresListFragment.footerView, (int)R.color.pbi_footer_color_dark, (int)R.color.pbi_footer_color_light);
        }
    }

    @Override
    public void showFooterView() {
        FeaturesListFragment featuresListFragment = featuresListFragment.loadMoreProgressBar;
        if (featuresListFragment != null) {
            featuresListFragment.setVisibility(0);
        }
    }

    @Override
    public void hideFooterView() {
        FeaturesListFragment featuresListFragment = featuresListFragment.loadMoreProgressBar;
        if (featuresListFragment != null) {
            featuresListFragment.setVisibility(8);
        }
    }

    public void onDestroy() {
        FeaturesListFragment featuresListFragment = featuresListFragment2;
        super.onDestroy();
        FeaturesListFragment featuresListFragment2 = featuresListFragment.presenter;
        if (featuresListFragment2 != null) {
            ((FeaturesListPresenter)((Object)featuresListFragment2)).onDestroy();
        }
    }

    @Override
    public void onVoteChange() {
        Object object = object.featureAdapter;
        if (object != null) {
            object.notifyDataSetChanged();
        }
    }

    public void onRefresh() {
        FeaturesListFragment featuresListFragment = featuresListFragment2;
        featuresListFragment.registerLoadMoreListener();
        FeaturesListFragment featuresListFragment2 = featuresListFragment.presenter;
        if (featuresListFragment2 != null) {
            ((FeaturesListPresenter)((Object)featuresListFragment2)).onPullToRefreshTriggered();
        }
    }

    @Override
    public void setRefreshing(boolean bl) {
        FeaturesListFragment featuresListFragment = featuresListFragment.swipeRefreshLayout;
        if (featuresListFragment != null) {
            featuresListFragment.setRefreshing(bl);
        }
    }

    @Override
    public void hideLoadMore() {
        this.hideFooterView();
    }

    @Override
    public void updateItemsOrder() {
        ListView listView = featuresListFragment2.listView;
        if (listView != null) {
            listView.smoothScrollToPosition(0);
        }
        FeaturesListFragment featuresListFragment = featuresListFragment2;
        featuresListFragment.registerLoadMoreListener();
        FeaturesListFragment featuresListFragment2 = featuresListFragment.presenter;
        if (featuresListFragment2 != null) {
            ((FeaturesListPresenter)((Object)featuresListFragment2)).onSortActionChanged();
        }
    }

    @Override
    public void showErrorToastMessage() {
        if (this.getActivity() != null) {
            FeaturesListFragment featuresListFragment = this;
            featuresListFragment.showToast(featuresListFragment.getLocalizedString(R.string.feature_requests_error_state_sub_title));
        }
    }
}

