/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.settings;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.instabug.library.Instabug;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;

public class PersistableSettings {
    private static PersistableSettings persistableSettings;
    private SharedPreferences sharedPreferences;
    private SharedPreferences.Editor editor;

    @SuppressLint(value={"CommitPrefEdits"})
    private PersistableSettings(Context context) {
        context = CoreServiceLocator.getInstabugSharedPreferences((Context)context, (String)"instabug_feature_requests");
        this.sharedPreferences = context;
        if (context != null) {
            this.editor = context.edit();
        }
    }

    public static void init(Context context) {
        persistableSettings = new PersistableSettings(context);
    }

    public static PersistableSettings getInstance() {
        if (persistableSettings == null && Instabug.getApplicationContext() != null) {
            PersistableSettings.init(Instabug.getApplicationContext());
        }
        return persistableSettings;
    }

    public void setLastSortByAction(int n) {
        SharedPreferences.Editor editor = this.editor;
        if (editor == null) {
            return;
        }
        editor.putInt("last_sort_by_action", n);
        this.editor.apply();
    }

    public int getLastSortByAction() {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return 0;
        }
        return persistableSettings.getInt("last_sort_by_action", 0);
    }

    public long getLastActivityTime() {
        PersistableSettings persistableSettings = persistableSettings.sharedPreferences;
        if (persistableSettings == null) {
            return 0L;
        }
        return persistableSettings.getLong("last_activity", 0L);
    }

    public void setLastActivityTime(long l) {
        SharedPreferences.Editor editor = this.editor;
        if (editor == null) {
            return;
        }
        editor.putLong("last_activity", l);
        this.editor.apply();
    }
}

