/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.models;

import android.annotation.SuppressLint;
import androidx.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.Serializable;
import org.json.JSONObject;

public class FeatureRequest
implements Cacheable,
Serializable {
    private long featureId;
    private String title;
    private String description;
    private Status status;
    private String colorCode;
    private String creatorName;
    private long date;
    private int likesCount;
    private int commentsCount;
    private boolean isLiked;
    @Nullable
    private String requesterName;
    private String requesterEmail;
    private String deviceToken;
    private UserVoteStatus userVoteStatus = UserVoteStatus.NOTHING;

    public long getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(long l) {
        this.featureId = l;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string2) {
        this.title = string2;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public int getLikesCount() {
        return this.likesCount;
    }

    public void setLikesCount(int n) {
        this.likesCount = n;
    }

    public int getCommentsCount() {
        return this.commentsCount;
    }

    public void setCommentsCount(int n) {
        this.commentsCount = n;
    }

    public boolean isLiked() {
        return this.isLiked;
    }

    public void setLiked(boolean bl) {
        this.isLiked = bl;
    }

    public UserVoteStatus getUserVoteStatus() {
        return this.userVoteStatus;
    }

    public void setUserVoteStatus(UserVoteStatus userVoteStatus) {
        this.userVoteStatus = userVoteStatus;
    }

    public String getColorCode() {
        return this.colorCode;
    }

    public void setColorCode(String string2) {
        this.colorCode = string2;
    }

    public long getDate() {
        return this.date;
    }

    public void setDate(long l) {
        this.date = l;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String string2) {
        this.creatorName = string2;
    }

    @Nullable
    public String getRequesterName() {
        return this.requesterName;
    }

    public String getRequesterEmail() {
        return this.requesterEmail;
    }

    public String getDeviceToken() {
        return this.deviceToken;
    }

    public JSONObject getFeatureJsonObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("title", (Object)this.getTitle()).put("description", (Object)this.getDescription());
        return jSONObject;
    }

    public String toJson() {
        JSONObject jSONObject = new JSONObject();
        long l = this.getFeatureId();
        JSONObject jSONObject2 = jSONObject.put("id", l).put("title", (Object)this.getTitle()).put("description", (Object)this.getDescription()).put("status", this.getStatus().toInt());
        l = this.getDate();
        jSONObject2.put("date", l).put("likes_count", this.getLikesCount()).put("comments_count", this.getCommentsCount()).put("liked", this.isLiked()).put("ib_user_vote_status", this.getUserVoteStatus().toInt()).put("color_code", (Object)this.getColorCode()).put("creator_name", (Object)this.getCreatorName());
        return jSONObject.toString();
    }

    public void fromJson(String string2) {
        JSONObject jSONObject;
        InstabugSDKLogger.v((String)"IBG-FR", (String)("Parsing feature request: " + string2));
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject(string2);
        if (jSONObject2.has("id")) {
            this.setFeatureId(jSONObject2.getLong("id"));
        }
        if (jSONObject2.has("title")) {
            this.setTitle(jSONObject2.getString("title"));
        }
        if (jSONObject2.has("description")) {
            this.setDescription(jSONObject2.getString("description"));
        }
        if (jSONObject2.has("creator_name")) {
            this.setCreatorName(jSONObject2.getString("creator_name"));
        }
        this.handleFeatureStatus(jSONObject2);
        if (jSONObject2.has("color_code")) {
            this.setColorCode(jSONObject2.getString("color_code"));
        }
        if (jSONObject2.has("likes_count")) {
            this.setLikesCount(jSONObject2.getInt("likes_count"));
        }
        if (jSONObject2.has("date")) {
            this.setDate(jSONObject2.getLong("date"));
        }
        if (jSONObject2.has("comments_count")) {
            this.setCommentsCount(jSONObject2.getInt("comments_count"));
        }
        if (jSONObject2.has("liked")) {
            this.setLiked(jSONObject2.getBoolean("liked"));
        }
        this.updateVoteStatus(jSONObject2);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string2) {
        this.description = string2;
    }

    public boolean isCompleted() {
        return this.getStatus() == Status.Completed;
    }

    @SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
    public FeatureRequest(@Nullable String string2, String string3, String string4) {
        this.status = Status.Open;
        this.featureId = System.currentTimeMillis() / 1000L;
        this.requesterName = string2;
        this.requesterEmail = string3;
        this.deviceToken = string4;
    }

    private void updateVoteStatus(JSONObject jSONObject) {
        if (jSONObject.has("ib_user_vote_status")) {
            switch (jSONObject.getInt("ib_user_vote_status")) {
                default: {
                    this.setUserVoteStatus(UserVoteStatus.NOTHING);
                    break;
                }
                case 3: {
                    this.setUserVoteStatus(UserVoteStatus.USER_UN_VOTED);
                    break;
                }
                case 2: {
                    this.setUserVoteStatus(UserVoteStatus.USER_VOTED_UP);
                    break;
                }
                case 1: {
                    this.setUserVoteStatus(UserVoteStatus.UPLOADED);
                    break;
                }
                case 0: {
                    this.setUserVoteStatus(UserVoteStatus.NOTHING);
                }
            }
        }
    }

    private void handleFeatureStatus(JSONObject jSONObject) {
        if (jSONObject.has("status")) {
            switch (jSONObject.getInt("status")) {
                default: {
                    break;
                }
                case 4: {
                    this.setStatus(Status.MaybeLater);
                    break;
                }
                case 3: {
                    this.setStatus(Status.Completed);
                    break;
                }
                case 2: {
                    this.setStatus(Status.InProgress);
                    break;
                }
                case 1: {
                    this.setStatus(Status.Planned);
                    break;
                }
                case 0: {
                    this.setStatus(Status.Open);
                }
            }
        }
    }

    public static enum UserVoteStatus {
        NOTHING(0),
        UPLOADED(1),
        USER_VOTED_UP(2),
        USER_UN_VOTED(3);

        private int status;

        private UserVoteStatus(int n2) {
            this.status = n2;
        }

        public int toInt() {
            return this.status;
        }
    }

    public static enum Status {
        Open(0),
        Planned(1),
        InProgress(2),
        Completed(3),
        MaybeLater(4);

        private int status;

        private Status(int n2) {
            this.status = n2;
        }

        public int toInt() {
            return this.status;
        }
    }
}

