package com.instabug.featuresrequest.ui.featuresmain.mainallfeatures;

import android.os.Bundle;

import com.instabug.featuresrequest.ui.base.FeaturesListBo;
import com.instabug.featuresrequest.ui.base.featureslist.FeaturesListFragment;
import com.instabug.featuresrequest.ui.base.featureslist.FeaturesListPresenter;

import androidx.annotation.NonNull;

/**
 * @author hossam.
 */

public class MainAllFeaturesFragment extends FeaturesListFragment {


    public static MainAllFeaturesFragment newInstance(boolean sortByTopVoted) {
        Bundle args = new Bundle();
        args.putBoolean(KEY_SORT_BY_TOP_VOTED, sortByTopVoted);
        args.putBoolean(KEY_MY_POSTS, false);
        MainAllFeaturesFragment fragment = new MainAllFeaturesFragment();
        fragment.setArguments(args);
        return fragment;
    }

    @NonNull
    @Override
    public FeaturesListPresenter getPresenter() {
        return new MainAllFeaturesPresenter(this,
                new FeaturesListBo(MainAllFeaturesDao.getInstance()));
    }

}
