package com.instabug.featuresrequest.network.service;

import androidx.annotation.Nullable;

import com.instabug.featuresrequest.Constants;
import com.instabug.featuresrequest.cache.FeatureRequestsDBHelper;
import com.instabug.featuresrequest.models.FeatureRequest;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugNetworkJob;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestMethod;
import com.instabug.library.util.InstabugSDKLogger;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

/**
 * Created by mohamedzakaria on 9/18/17.
 */
public class FeaturesRequestVoteJob extends InstabugNetworkJob {
    @Nullable
    private static FeaturesRequestVoteJob INSTANCE;

    private FeaturesRequestVoteJob() {
    }

    public synchronized static FeaturesRequestVoteJob getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FeaturesRequestVoteJob();
        }

        return INSTANCE;
    }

    private static void submitVotes() throws JSONException {
        InstabugSDKLogger.d(Constants.LOG_TAG, "submitVotes started");
        List<FeatureRequest> featuresList = FeatureRequestsDBHelper.retrieve();
        for (final FeatureRequest featureRequest : featuresList) {
            switch (featureRequest.getUserVoteStatus()) {
                case USER_VOTED_UP:
                    sendVoteRequestWithMethod(featureRequest, RequestMethod.POST);
                    break;
                case USER_UN_VOTED:
                    sendVoteRequestWithMethod(featureRequest, RequestMethod.DELETE);
                    break;
                default:
                    break;
            }
        }
    }


    private static void sendVoteRequestWithMethod(final FeatureRequest featureRequest, String method) {

        if (Instabug.getApplicationContext() == null) return;

        FeaturesRequestService.getInstance().vote(featureRequest.getFeatureId(),
                method,
                new Request.Callbacks<JSONObject, Throwable>() {
                    @Override
                    public void onSucceeded(@Nullable JSONObject response) {
                        FeatureRequestsDBHelper.delete(featureRequest.getFeatureId() + "");
                    }

                    @Override
                    public void onFailed(Throwable error) {
                        if (error.getMessage() != null) {
                            InstabugSDKLogger.e(Constants.LOG_TAG, error.getMessage(), error);
                        }
                    }
                });
    }

    public void start() {
        enqueueJob(Constants.LOG_TAG, new Runnable() {
            @Override
            public void run() {
                try {
                    submitVotes();
                } catch (Exception e) {
                    InstabugSDKLogger.e(Constants.LOG_TAG, "Error " + e.getMessage() + "occurred while voting for feature", e);
                }
            }
        });
    }
}
