package com.instabug.featuresrequest.models;

import android.annotation.SuppressLint;

import com.instabug.featuresrequest.Constants;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.user.UserManagerWrapper;
import com.instabug.library.util.InstabugSDKLogger;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by mohamedzakaria on 10/1/17.
 */
public class FeatureRequestResponse implements Cacheable, Serializable {

    public static final String KEY_COMPLETED_FEATURES_COUNT = "completed_features_count";
    public static final String KEY_NEXT_PAGE = "has_next_page";
    public static final String KEY_FEATURE_REQUESTS = "feature_reqs";
    private int completedFeaturesCount;
    private boolean hasNextPage;
    private List<FeatureRequest> featureRequestList = new ArrayList<FeatureRequest>();

    public static FeatureRequestResponse fromJson(JSONObject featureJsonObject)
            throws JSONException {

        FeatureRequestResponse res = new FeatureRequestResponse();
        res.fromJson(featureJsonObject.toString());
        return res;
    }

    public int getCompletedFeaturesCount() {
        return completedFeaturesCount;
    }

    public void setCompletedFeaturesCount(int completedFeaturesCount) {
        this.completedFeaturesCount = completedFeaturesCount;
    }

    public boolean hasNextPage() {
        return hasNextPage;
    }

    public void setHasNextPage(boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
    }

    public List<FeatureRequest> getFeatureRequestList() {
        return featureRequestList;
    }

    public void setFeatureRequestList(List<FeatureRequest> featureRequestList) {
        this.featureRequestList = featureRequestList;
    }

    @Override
    public String toJson() throws JSONException {
        JSONObject featureJsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        for (FeatureRequest request : getFeatureRequestList()){
            jsonArray.put(request.toJson());
        }
        featureJsonObject
                .put(KEY_NEXT_PAGE, hasNextPage())
                .put(KEY_COMPLETED_FEATURES_COUNT, getCompletedFeaturesCount())
                .put(KEY_FEATURE_REQUESTS, jsonArray);
        return featureJsonObject.toString();
    }

    @Override
    public void fromJson(String modelAsJson) throws JSONException {
        InstabugSDKLogger.v(Constants.LOG_TAG, "Parsing feature request response: " + modelAsJson);

        JSONObject featureResponseObject = new JSONObject(modelAsJson);

        if (featureResponseObject.has(KEY_COMPLETED_FEATURES_COUNT)) {
            setCompletedFeaturesCount(featureResponseObject.getInt(KEY_COMPLETED_FEATURES_COUNT));
        }

        if (featureResponseObject.has(KEY_NEXT_PAGE)) {
            setHasNextPage(featureResponseObject.getBoolean(KEY_NEXT_PAGE));
        }

        if (featureResponseObject.has(KEY_FEATURE_REQUESTS)) {
            List<FeatureRequest> featureRequestList = new ArrayList<>();
            JSONArray featuresListArr = featureResponseObject.getJSONArray(KEY_FEATURE_REQUESTS);
            for (int i = 0; i < featuresListArr.length(); i++) {
                JSONObject featureObject = new JSONObject(featuresListArr.getString(i));
                FeatureRequest featureRequest = new FeatureRequest(UserManagerWrapper.getUserName(), UserManagerWrapper.getUserEmail(), InstabugCore.getPushNotificationToken());
                featureRequest.fromJson(featureObject.toString());
                featureRequestList.add(featureRequest);
            }
            setFeatureRequestList(featureRequestList);
        }
    }
}
