/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import com.instabug.bug.b.a;
import com.instabug.bug.settings.a;
import com.instabug.chat.ChatsDelegate;
import com.instabug.library.APIBuildChecker;
import com.instabug.library.Feature;
import com.instabug.library.OnSdkDismissCallback;
import com.instabug.library.OnSdkDismissedCallback;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.extendedbugreport.ExtendedBugReport;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.invocation.OnInvokeCallback;
import com.instabug.library.invocation.util.InstabugFloatingButtonEdge;
import com.instabug.library.invocation.util.InstabugVideoRecordingButtonPosition;
import com.instabug.library.settings.SettingsManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class BugReporting {
    public static void setInvocationEvents(InstabugInvocationEvent ... invocationEvents) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("instabugInvocationEvent").setType(InstabugInvocationEvent.class).setValue((Object)TextUtils.join((CharSequence)",", (Object[])invocationEvents))});
        InvocationManager.getInstance().setInstabugInvocationEvent(invocationEvents);
    }

    public static void setOptions(int ... options) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("options").setType(int[].class)});
        com.instabug.bug.a.b(options);
    }

    public static void setOnInvokeCallback(OnInvokeCallback onInvokeCallback) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("setOnInvokeCallback").setType(Runnable.class)});
        SettingsManager.getInstance().setOnInvokeCallback(onInvokeCallback);
    }

    public static void setOnDismissCallback(OnSdkDismissCallback onSdkDismissedCallback) throws IllegalStateException {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("onSdkDismissedCallback").setType(OnSdkDismissedCallback.class)});
        ChatsDelegate.setOnSdkDismissCallback((OnSdkDismissCallback)onSdkDismissedCallback);
        a.a().a(onSdkDismissedCallback);
    }

    public static void setShakingThreshold(int threshold) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("threshold").setType(Integer.TYPE).setValue((Object)Integer.toString(threshold))});
        InvocationManager.getInstance().getCurrentInvocationSettings().setShakingThreshold(threshold);
    }

    public static void setFloatingButtonEdge(@NonNull InstabugFloatingButtonEdge instabugFloatingButtonEdge) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("instabugFloatingButtonEdge").setType(InstabugFloatingButtonEdge.class).setValue((Object)instabugFloatingButtonEdge)});
        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(instabugFloatingButtonEdge);
    }

    public static void setFloatingButtonOffset(@IntRange(from=0L) int floatingButtonOffsetFromTop) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("floatingButtonOffsetFromTop").setType(Integer.TYPE).setValue((Object)Integer.toString(floatingButtonOffsetFromTop))});
        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonOffsetFromTop(floatingButtonOffsetFromTop);
    }

    public static void setVideoRecordingFloatingButtonPosition(@NonNull InstabugVideoRecordingButtonPosition instabugViewRecordingButtonPosition) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("instabugViewRecordingButtonPosition").setType(InstabugVideoRecordingButtonPosition.class).setValue((Object)instabugViewRecordingButtonPosition)});
        InvocationManager.getInstance().getCurrentInvocationSettings().setVideoRecordingButtonPosition(instabugViewRecordingButtonPosition);
    }

    public static void setExtendedBugReportState(ExtendedBugReport.State state) {
        a.a a2;
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        switch (state) {
            case ENABLED_WITH_REQUIRED_FIELDS: {
                a2 = a.a.ENABLED_WITH_REQUIRED_FIELDS;
                break;
            }
            case ENABLED_WITH_OPTIONAL_FIELDS: {
                a2 = a.a.ENABLED_WITH_OPTIONAL_FIELDS;
                break;
            }
            default: {
                a2 = a.a.DISABLED;
            }
        }
        a.a().a(a2);
    }

    @RequiresApi(value=21)
    public static void setAutoScreenRecordingEnabled(boolean autoScreenRecordingEnabled) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("setAutoScreenRecordingEnabled").setType(Boolean.class).setValue((Object)String.valueOf(autoScreenRecordingEnabled))});
        com.instabug.bug.a.a(autoScreenRecordingEnabled);
    }

    public static void setReportTypes(int ... types) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("types").setType(int[].class)});
        com.instabug.bug.a.a(types);
    }

    public static void show(@ReportType int type) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("type").setType(Integer.TYPE)});
        com.instabug.bug.a.a(type);
    }

    public static void show(@ReportType int type, int ... options) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("type").setType(Integer.TYPE)});
        com.instabug.bug.a.a(type, options);
    }

    public static void setState(Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("state").setType(Feature.State.class)});
        com.instabug.bug.a.a(state);
    }

    public static void setViewHierarchyState(@NonNull Feature.State state) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state)});
        InstabugCore.setFeatureState((Feature)Feature.VIEW_HIERARCHY_V2, (Feature.State)state);
    }

    public static void setAttachmentTypesEnabled(boolean initialScreenshot, boolean extraScreenshot, boolean imageFromGallery, boolean screenRecording) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("initialScreenshot").setType(Boolean.class).setValue((Object)Boolean.toString(initialScreenshot)), new Api.Parameter().setName("extraScreenshot").setType(Boolean.class).setValue((Object)Boolean.toString(extraScreenshot)), new Api.Parameter().setName("galleryImage").setType(Boolean.class).setValue((Object)Boolean.toString(imageFromGallery)), new Api.Parameter().setName("screenRecording").setType(Boolean.class).setValue((Object)Boolean.toString(screenRecording))});
        InstabugCore.setInitialScreenShotAllowed((boolean)initialScreenshot);
        com.instabug.bug.a.a(initialScreenshot, extraScreenshot, imageFromGallery, screenRecording);
    }

    @RequiresApi(value=21)
    public static void setScreenshotByMediaProjectionEnabled(boolean enabled) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        SettingsManager.getInstance().setScreenshotByMediaProjectionEnabled(enabled);
    }

    protected static void setScreenshotRequired(boolean screenshotRequired) {
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("screenshotRequired").setType(Boolean.TYPE)});
        a.a().e(screenshotRequired);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ReportType {
        public static final int BUG = 0;
        public static final int FEEDBACK = 1;
        public static final int QUESTION = 2;
    }
}

