package com.instabug.chat.annotation.recognition;

import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;

import androidx.annotation.Nullable;

import com.instabug.library.util.DrawingUtility;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by tarek on 11/6/16.
 */

public class PathFactory {

    private static final float arrowLength = ShapeSpecs.DIMEN / 3;

    public static Path getArrowPath() {

        PointF tailPoint = new PointF(0, ShapeSpecs.DIMEN / 2);
        PointF headPoint = new PointF(ShapeSpecs.DIMEN, ShapeSpecs.DIMEN / 2);

        float rotation = DrawingUtility.getRotationDegrees(headPoint.x, headPoint.y, tailPoint.x,
                tailPoint.y);
        PointF headLeftPoint = DrawingUtility.pointOnCircle(arrowLength, rotation + 225, headPoint);
        PointF headRightPoint = DrawingUtility.pointOnCircle(arrowLength, rotation + 135, headPoint);

        Path path = new Path();
        path.moveTo(tailPoint.x, tailPoint.y);
        path.lineTo(headPoint.x, headPoint.y);
        path.moveTo(headLeftPoint.x, headLeftPoint.y);
        path.lineTo(headPoint.x, headPoint.y);
        path.lineTo(headRightPoint.x, headRightPoint.y);

        return path;

    }


    private static List<RectPath> rectPaths;
    private static List<RectPath> ovalPaths;

    @Nullable
    public static List<RectPath> getRectPaths(ShapeSpecs.Type type) {

        if (type == ShapeSpecs.Type.RECT) {
            if (rectPaths != null) {
                return rectPaths;
            } else {
                rectPaths = new ArrayList<>();
            }
        } else if (type == ShapeSpecs.Type.OVAL) {
            if (ovalPaths != null) {
                return ovalPaths;
            } else {
                ovalPaths = new ArrayList<>();
            }
        }

        RectF rect = new RectF(0, 0, ShapeSpecs.DIMEN, ShapeSpecs.DIMEN);
        for (int i = 0; i < ShapeSpecs.DIMEN / 2 - 2; i++) {
            RectPath rectPath = new RectPath();
            rect.left++;
            rect.right--;
            if (type == ShapeSpecs.Type.RECT) {
                rectPath.path.addRect(rect, Path.Direction.CW);
                rectPaths.add(rectPath);
            } else if (type == ShapeSpecs.Type.OVAL) {
                rectPath.path.addOval(rect, Path.Direction.CW);
                ovalPaths.add(rectPath);
            }
            rectPath.paddingPercent = rect.left / ShapeSpecs.DIMEN;
        }

        if (type == ShapeSpecs.Type.RECT) {
            return rectPaths;
        } else if (type == ShapeSpecs.Type.OVAL) {
            return ovalPaths;
        } else {
            return null;
        }

    }

}
