package com.instabug.bug.view.reporting.bugreporting;

import android.annotation.SuppressLint;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.bug.Constants;
import com.instabug.bug.extendedbugreport.ExtendedBugReport;
import com.instabug.bug.settings.BugSettings;
import com.instabug.bug.userConsent.UserConsentRepository;
import com.instabug.bug.userConsent.UserConsentsManager;
import com.instabug.bug.view.reporting.BaseReportingPresenter;
import com.instabug.bug.view.reporting.IBaseReportingView;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.util.PlaceHolderUtils;

/**
 * A presenter responsible for bug reporting experience, extend same shared reporting experience
 * among bug,feedback and chats
 * <p>
 * FUNCTIONS
 * 1- bug report type.
 * 2- hint message.
 * ****************************
 * DEPENDENCIES
 * 1- PlaceholderUtils {@link PlaceHolderUtils}
 * </P>
 */
public class BugReportingPresenter extends BaseReportingPresenter {
    public BugReportingPresenter(
            IBaseReportingView.View view,
            @NonNull UserConsentsManager userConsentsManager
    ) {
        super(view, userConsentsManager);
    }

    @Override
    @Constants.ReportType
    protected String getReportType() {
        return Constants.ReportType.BUG;
    }

    @Override
    @Nullable
    @SuppressLint("ERADICATE_INCONSISTENT_SUBCLASS_RETURN_ANNOTATION")
    public String getMessageHint() {
        String defaultMessage = "";
        if (view != null) {
            IBaseReportingView.View view = this.view.get();
            if (view != null) {
                defaultMessage = view.provideDefaultHintMessage();
            }
        }
        return PlaceHolderUtils.getPlaceHolder(
                InstabugCustomTextPlaceHolder.Key.COMMENT_FIELD_HINT_FOR_BUG_REPORT,
                defaultMessage);
    }

    @Override
    @Nullable
    @SuppressLint("ERADICATE_INCONSISTENT_SUBCLASS_RETURN_ANNOTATION")
    public String getTitle() {
        String defaultTitle = "";
        if (view != null) {
            IBaseReportingView.View view = this.view.get();
            if (view != null) {
                defaultTitle = view.provideDefaultTitle();
            }
        }
        return PlaceHolderUtils.getPlaceHolder(
                InstabugCustomTextPlaceHolder.Key.REPORT_BUG,
                defaultTitle);
    }

    @Override
    public boolean hasExtendedReport() {
        return !BugSettings.getInstance().getExtraReportFields().isEmpty()
                || BugSettings.getInstance().getExtendedBugReportState()
                != ExtendedBugReport.State.DISABLED;
    }
}


